#ifndef _____RGL_GRAPHOPS___H___
#define _____RGL_GRAPHOPS___H___

#include "graph.h"
#include "set.h"

BEGIN_C_DECL

#define LEXP 0x01
#define LEXM 0x02
#define MCS 0x04
#define FASTSEED 0x10
#define MCSSEED 0x20

extern int sign, tiebreaker, tiebreaker_2;

typedef boolean_t (*vertex_predicate)(graph_t g, pointer_t context, int vertex);

set_t graph_forward_reachable_set(graph_t g, int init, vertex_predicate pred, pointer_t ptr);
set_t graph_backward_reachable_set(graph_t g, int init, vertex_predicate pred, pointer_t ptr);
boolean_t graph_forward_is_reachable(graph_t g, int init, int target, vertex_predicate pred, pointer_t ptr);
boolean_t graph_backward_is_reachable(graph_t g, int init, int target, vertex_predicate pred, pointer_t ptr);

int triangulate_graph(graph_t g, int *elim);
int triangulate_graph_nodisconnect(graph_t g, int *elim);
void lexicographic_bfs_graph(graph_t g, int seed, int *elim);
void lexicographic_bfs_graph_min(graph_t g, int seed, int *elim);
void mcs_graph(graph_t g, int seed, int *elim);
void min_induced_width_graph(graph_t g, int *elim);
void min_fill_graph(graph_t g, int *elim);

graph_t build_tree_decomposition_graph(graph_t g, int *elim);
void reroot_tree_decomposition_graph(graph_t td, set_t target, int *elim);

void build_vo_graph(graph_t g, int options, int *elim);
void mcs_graph_seed(graph_t g, set_t seed, int *elim);
void mcs_graph_layered(graph_t g, int *elim);

void optimize_graph_mixed(graph_t g, int *elim);

void sift_graph_width(graph_t g, int count, int *elim);

int get_fill_size(graph_t g, set_t neighbors);

END_C_DECL

#endif
