#ifndef _____RGL_GRAPHWEIGHTED___H___
#define _____RGL_GRAPHWEIGHTED___H___

#include "graph.h"
#include "graphops.h"
#include "set.h"

BEGIN_C_DECL

graph_t alloc_graph_weighted(int vertices);
void free_graph_weighted(graph_t g);
void connect_graph_weighted(graph_t g, int a, int b, int w);
void mcs_graph_weighted(graph_t g, int seed, int *elim);
void mcs_graph_seed_weighted(graph_t g, set_t seed, int *elim);

typedef int (GraphWeightedContractionProc)(graph_t g, int v, set_t neighbors);

void miw_graph_weighted(graph_t g, set_t seed, int *elim, GraphWeightedContractionProc gwcp);
void mf_graph_weighted(graph_t g, set_t seed, int *elim, GraphWeightedContractionProc gwcp);
void mf_weight_graph_weighted(graph_t g, set_t seed, int *elim, GraphWeightedContractionProc gwcp);

int update_edge_weight_contract_graph_weighted(graph_t g, int v, set_t neighbors);



typedef pointer_t hypergraph_t;
typedef int (*HypergraphContractWeightProc)(hypergraph_t g, set_t edges, int id);

hypergraph_t alloc_hypergraph(int vertices);
void free_hypergraph(hypergraph_t hg);
int add_hyperedge_hypergraph(hypergraph_t hg, set_t he, int weight);
set_t hyperedges_hypergraph(hypergraph_t hg);
set_t vertices_hypergraph(hypergraph_t hg);
set_t out_hyperedges_from_vertex_hypergraph(hypergraph_t hg, int id);
set_t out_vertices_from_vertex_hypergraph(hypergraph_t hg, int id);
set_t out_vertices_from_hyperedge_hypergraph(hypergraph_t hg, int id);
void contract_vertex_hypergraph(hypergraph_t hg, int id);
void associate_vertex_hypergraph(hypergraph_t hg, int v, pointer_t p);
void associate_hyperedge_hypergraph(hypergraph_t hg, int v, pointer_t p);
pointer_t mapsto_vertex_hypergraph(hypergraph_t hg, int v);
pointer_t mapsto_hyperedge_hypergraph(hypergraph_t hg, int v);
graph_t get_bipartite_graph_hypergraph(hypergraph_t hg);

void mcs_hypergraph(hypergraph_t hg, int seed, int *elim);
void miw_hypergraph(hypergraph_t hg, int *elim);
void mcs_hypergraph_seed_set(hypergraph_t hg, set_t seed, int *elim);

END_C_DECL

#endif
