#include "bool_global.h"

// Initialize the static member
int 
bool_formula::number_of_formulas = 0;

/**
 * The constructor
 */
bool_formula::bool_formula(bool_operator* o, bool_formula* f1, bool_formula* f2) {
  op = o;
  left_formula = f1;
  right_formula = f2;
  number_of_formulas++;
}


/**
 * Destructor
 */
bool_formula::~bool_formula() {
  if (op != 0) {
#ifdef DEBUG
    std::cout << "~bool_formula(): deleting operator " << op->to_string() << std::endl;
#endif
    delete op;
  }

  if (left_formula != 0) {
#ifdef DEBUG
    std::cout << "~bool_formula(): deleting formula " << left_formula->to_string() << std::endl;
#endif
    delete left_formula;
  }

  if (right_formula != 0) {
#ifdef DEBUG
    std::cout << "~bool_formula(): deleting formula " << right_formula->to_string() << std::endl;
#endif
    delete right_formula;
  }

#ifdef DEBUG  
  std::cout << "Number of outstanding operators: " << bool_operator::unfreed_operators() << std::endl;
#endif

  number_of_formulas--;
}




/**
 * Returns the string corresponding to this formula. The precedence
 * argument determines where we are going to put the parentheses.
 */
std::string
bool_formula::to_string(op_prec_t precedence) {
  return op->to_string(left_formula, right_formula, precedence);
}


/**
 * Evaluates the formula using the argument @truth_assignment to
 * determine the truth values of the atomic propositions.
 */
bool
bool_formula::eval(sbmap_t* truth_assignment) {
  return op->eval(left_formula, right_formula, truth_assignment);
}
