#ifndef BOOL_PARSER_H
#define BOOL_PARSER_H

#include <string>
#include <stdio.h>
#include <ctype.h> // isalnum()

#include "bool_global.h"

class bool_parser {
  
 public:
  // Constructor
  bool_parser();

  bool_formula*  parse(std::string s);
  bool_formula*  parse_to_precedence(op_prec_t prec);
  bool_formula*  read_one_term();
  std::string*   next_token();
  void           skip_white_space();
  std::string*   read_token();
  void           consume(std::string s);
  std::string*   read_next(int length);
  bool_operator* get_operator(std::string s);

 protected:
  int index, back_index;
  char* input;
  int input_size;

}; // class

#endif
