#ifndef BACK_NONDETERMINISTIC_H
#define BACK_NONDETERMINISTIC_H

#include <iostream>

#include "ir2monitor.h"

namespace mm {
  namespace ir_visitors {
/**
 * Print the automaton in back-encoding
 */
class back_nondeterministic_visitor : public ir2monitor {

 public:
  // Constructor
  back_nondeterministic_visitor(global_params*,
				monitor_params*,
				std::ostream&,
				std::ostream&);
  // Destructor
  virtual ~back_nondeterministic_visitor();
  
  virtual void begin(intermediate_rep* automaton);
  virtual void process_state(state_t* state);
  virtual void process_outgoing(transition_t* trans);
  virtual void process_incoming(transition_t* trans);
  virtual void end();

 protected:
  void step_footer();
  
 private:
  bool semicolon_needed;
  int accept_all_state_id;
};


  } //namespace ir_visitors
} // namespace mm
#endif
