#ifndef FRONT_DET_ASSIGN_ALPHABETIZED_IFELSE_H
#define FRONT_DET_ASSIGN_ALPHABETIZED_IFELSE_H

#include <iostream>

#include "ir2det_monitor.h"

namespace mm {
  namespace ir_visitors {
/**
 * Generates a monitor for the desired specification. Uses the "front
 * monitor" paradigm where we explicitly check what states are enabled
 * in the current step, and then determine which states will be
 * enabled in the next step, based on the truth values of all atoms in
 * the system. Here we explicitly reduce the state of the system
 * (i.e. truth values of all atomic propositions) to an integer, and
 * all transitions in the step() function are based on comparison with
 * this integer.
 */
class front_det_assign_alphabetized_ifelse : public ir2det_monitor {

 public:
  // Constructor
  front_det_assign_alphabetized_ifelse(global_params*,
				       monitor_params*,
				       std::ostream&,
				       std::ostream&);
  // Destructor
  virtual ~front_det_assign_alphabetized_ifelse();
  
  virtual void begin(intermediate_rep* automaton);
  virtual void process_state(state_t* state);
  virtual void process_outgoing(transition_t* trans);
  virtual void process_incoming(transition_t* trans);
  virtual void end();

 protected:
  void step_footer();
  
 private:
  bool closing_brace_for_if_needed;
  bool inner_ifstatement_needed;
  bool elseif_needed;
};




  } //namespace ir_visitors
} // namespace mm
#endif
