#ifndef IR2MONITOR_H
#define IR2MONITOR_H

#include <ostream>

#include "ir_visitor.h"
#include "global_params.h"
#include "monitor_params.h"
#include "augment.h"
#include "utils.h"
#include "types.h"
#include "alphabetize.h"

// SPOT includes
#include "tgba/tgbatba.hh" // Definition of spot::tgba_sba_proxy*
#include "tgbaalgos/reductgba_sim.hh"  // Reduced automaton
#include "tgbaalgos/ltl2tgba_lacim.hh" // Initial automaton from LTL
#include "tgbaalgos/neverclaim.hh"     // SPIN neverclaim generation

namespace mm {
  namespace ir_visitors {
    
class ir2monitor : public mm::ir_visitors::ir_visitor {

 public:
  // Constructor
  ir2monitor(global_params* g,
	     monitor_params* m,
	     std::ostream& o,
	     std::ostream& h,
	     bool u);

  // Virtual destructor
  virtual ~ir2monitor() {};
  
  void monitor_header();
  void monitor_constructor(int initial_state_id);
  void register_with_observer();
  void observer_callbacks();
  void helper_functions();
  void monitor_class_variables();
  void step_header();
  void generate_value_callbacks();

  
 protected:
  global_params* gp;
  monitor_params* mp;
  std::ostream& os;
  std::ostream& header_os;
  std::string ltl_string;
  const spot::tgba_sba_proxy* s;
  int num_states;  //number of states in the monitor
  std::string this_monitor_name; // the name of the monitor class
  bool use_array;
  std::vector<std::string> kernel_clocks;
  

};


  } // namespace ir_visitors
} // namespace mm
#endif
