#ifndef IR_STATE_TRANS_COUNTER
#define IR_STATE_TRANS_COUNTER

#include "ir_visitor.h"

namespace mm{
  namespace ir_visitors {

/**
 * Counts the number of states and the number of transitions in the IR automaton.
 */
class ir_state_trans_counter_visitor : public ir_visitor {

 public:
  // Constructor
  ir_state_trans_counter_visitor(int* state_count, int* trans_count);

  virtual void process_state(state_t* state);
  virtual void process_outgoing(transition_t* trans);
  virtual void process_incoming(transition_t* trans);
  virtual void end();
  
 protected:
  int* num_states;
  int* num_trans;
  int incoming_trans;
  
}; // class



void count_ir_state_trans(intermediate_rep* ir, int* states, int* trans);
 
  } // namespace ir_visitors
} // namespace mm



#endif
