#ifndef IR_VISITOR_H
#define IR_VISITOR_H

#include "intermediate_rep.h"


// Forward declaration
class transition_t;
class state_t;
class intermediate_rep;

namespace mm {
  namespace ir_visitors {

/**
 * Generic visitor for automata in the intermediate representation.
 */
class ir_visitor{
 public:
  virtual void begin(intermediate_rep* automaton) {}
  virtual void process_state(state_t* state) {}
  virtual void process_outgoing(transition_t* trans) {}
  virtual void process_incoming(transition_t* trans) {}
  virtual void end() {}
};


  } // namespace ir_visitors
} // namespace mm
#endif
