#include "lbt_format.h"

namespace mm {
  namespace ir_visitors {

/**
 * Constructor
 */ 
lbt_format_visitor::lbt_format_visitor(std::ostream& str) :  os(str) {
  bookend = false;
}

/**
 * Destructor
 */
lbt_format_visitor::~lbt_format_visitor() {
  // Do nothing
}

void
lbt_format_visitor::begin(intermediate_rep* automaton) {
  // Number of states; number of accepting sets
  os << automaton->size() << " 1" << std::endl;
}

void
lbt_format_visitor::process_state(state_t* state) {
  if (bookend) {
    // Bookend the list of transitions for the previous state
    os << "-1" << std::endl;
  }
  
  os << state->get_state_id() << " "
     << state->is_initial() << " "
    // We treat all states as accepting for the purposes of
    // minimization because we are ignoring the acceptance property
    // anyways when we construct the monitor.
    //     << (state->is_accepting() ? "0 " : "")
     << "0 " // Mark it accepting (the 0-th accepting set)
     << "-1" << std::endl;

  bookend = true;
}

void
lbt_format_visitor::process_outgoing(transition_t* trans) {
  os << trans->get_dest() << " "
     << trans->get_guard() << std::endl;
}

void
lbt_format_visitor::process_incoming(transition_t* trans) {
  // just chill and do nothing
}

void
lbt_format_visitor::end() {
  if (bookend) {
    // Bookend the list of transitions for the last state
    os << "-1" << std::endl;
  }
}


void
ir2lbt(intermediate_rep* automaton, std::ostream& str) {
  lbt_format_visitor visitor(str);
  automaton->accept(&visitor);
}
  } // namespace ir_visitors
} // namespace mm
