#ifndef MONITOR_PARAMS
#define MONITOR_PARAMS

#include <string>
#include <iostream>
#include <cassert>
#include <sstream>

#include "types.h"


class monitor_params {

 public:

  // Constructor
  monitor_params();

  void set_formula(std::string parsed_formula);
  void set_formula(char* formula) { set_formula(std::string(formula)); }

  void get_ltl(std::string* container) { container->assign( ltl ); }
  void reset_ltl(std::string* new_ltl) {ltl = *new_ltl; }
  sset_t get_clocks() { return clocks; }
  
  /**
   * Stores another pair of (variable, type)
   */
  void add_vartype(std::string var, std::string type) { vartypes[var] = type; }
  ssmap_t get_vartypes() { return vartypes; }

  void to_stream(std::ostream& os) const;
  void to_string(std::string*);

  void get_id_str(std::string*);
  void get_f_quote_escaped(std::string* cont) { cont->assign(f_quote_escaped); }
  
  void set_num_states(int i) { num_states = i;}
  int get_num_states() { return num_states; }
  

 private:
  std::string ltl;
  std::string f_quote_escaped;
  std::string formula;
  sset_t clocks;
  ssmap_t vartypes;
  int num_states;
  int id;
  static int num_monitors;
}; // class


#endif
