#ifndef UTILS_H
#define UTILS_H

#include <string>

//#include <stdarg.h> // for variable argument functions
#include <sstream>
#include <iostream>
#include <fstream>

// For file status checking
#include <sys/stat.h>


#ifdef TIMING

void start_timer();
void display_and_reset_timer(const char* message);

#endif // TIMING


// Add a "//" at the beginning of each line
void comment_out_string(std::string* input);


void remove_str(const std::string source, std::string flags, std::ostream& os);
void remove_str(const std::string* input, const char* flags, std::string* output);
void quote_escape(std::string source, std::string* result);
bool prefix2inorder(std::ifstream& in, std::string* dest);
int str2int(const std::string& str);

void copy_without_surrounding_whitespace(const std::string* source,
					 std::string* destination);

std::ofstream*
open_for_output(const char* file_name);

void close_file(std::ofstream* file_handle);

void get_unique_file_name(std::string* container,
			  std::string* directory,
			  const char* prefix = "temp_file",
			  const char* extension = "tmp");

void get_naked_file_name(const char* full_name, std::string* container);
void get_capitalized_name(const char* file_name, std::string* container);

#endif // UTILS_H
