
/***************************************************************************************************

 The containment analyzer is useful for checking the containment of two Buechi
 automata. Based on a SCT analyzer by: 
 Copyright (C) 2004  Chin Soon Lee
 Further copyright (C) 2009 Seth Fogarty

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

 The authors can be contacted by e-mail at cslee_sg@hotmail.com and sfogarty@gmail.com.
***************************************************************************************************/


/**************************************************************************************************
DG (Edgeendency Graph) [now SRG (Size boolation Graph)] operations 

The subgraph of DG containing only deq (down-equal) arcs is called the NDG.
**************************************************************************************************/

/* Return a uniquified list of bstates in an s.c.g. SCC (s.c.g. set). */
//BStateList sgraphscc_to_bstates(SGraphList scc);

/* Set _out_edges fields of bstates according to sgraphs. This specifies the DG subgraph currently
   receiving attention. */
void setup_out_edges(BStateArray bstates,int bsize,SGraph sgraph);

/* Return whether each DG-component of bstates (vertices) satisfies prc. */

/* Return whether the intra-component arcs of component vs are deq-labeled */
bool is_deq_bstatecomp(BStateList vs); 		

/* Return the subset of sgraphs not flagged as anchors. */
SGraphList get_unflagged_sgraphs(SGraphList sgraphs);


void annotate_sgraph(SGraph sgraph);
BStateList reaching_one_scc(SGraph sgraph);
BStateList reachable_from_init(SGraph g);
