/***************************************************************************************************

 The containment analyzer is useful for checking the containment of two Buechi
 automata. Based on a SCT analyzer by: 
 Copyright (C) 2004  Chin Soon Lee
 Further copyright (C) 2009 Seth Fogarty

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

 The authors can be contacted by e-mail at cslee_sg@hotmail.com and sfogarty@gmail.com.

***************************************************************************************************/

/* Containment */

/* package together all the relevant info from a run of check_containment() */

typedef struct ContainmentRec {
  bool result;					/* result of analysis */
  int closure_size;				/* size of computed (nodetial) closure */
  SGraphList failure_prefix;				/* critical (failure) multipath */
  SGraphList failure_path;				/* critical (failure) multipath */
} *Containment;

Containment check_containment(CProb cg);				/* Containment analysis */

void free_containment(Containment ret_cont);			
void report_cont_failure(SGraphList prefix, SGraphList loop);		/* report the critical multipath */
bool subsumption;
