
/***************************************************************************************************

 The containment analyzer is useful for checking the containment of two Buechi
 automata. Based on a SCT analyzer by: 
 Copyright (C) 2004  Chin Soon Lee
 Further copyright (C) 2009 Seth Fogarty

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

 The authors can be contacted by e-mail at cslee_sg@hotmail.com and sfogarty@gmail.com.

***************************************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "std.h"
#include "sgraph.h"
#include "containment.h"

/* nodesing command line flags */

bool bool_flag(flag,argc,argv)  
  int argc;
  char *argv[],*flag; {
  int i;

  for (i=1; i<argc; i++)
    if (strcmp(argv[i],flag)==0) 
      return true;
  return false;
}

long int posi_flag(flag,argc,argv)
  int argc;
  char *argv[],*flag; {
  int i;
  long int res;

  for(i=1; i<argc-1; i++)    
    if (strcmp(flag,argv[i])==0 && (res= atol(argv[i+1]))>0)
      return res;
  return 1;
}

void report_usage() {
  printf("Usage: ramsey [-q] [-n] < file\n");
  //printf("\t -r <n>:  <n> will be the number of repetitions for each analysis.\n");
  //printf("\t     -E:  output data from experiment.\n");
  printf("\t     -q:  Do not print critical multipath or newline.\n");
  printf("\t     -n:  Do not use subsumption.\n");
  //printf("\t  --cln:  output clean sgraphs.\n");
  //printf("\t--ptime:  PTIME approximation.\n");
}
   
void do_scp(bool quiet) {
  /*CProb cg;
  SCP ret_scp;
  
  cg= parse_cp(); //cg_read();
  ret_scp= scp(cg);
  if (ret_scp->result) printf("(P)Contained\n");
  else if (ret_scp->precise) printf("(P)Not Contained\n");
  else printf("(P)Maybe Contained\n");
  if ((!quiet) && (!ret_scp->result))
      report_scp_failure(ret_scp->failure_set);
  free_scp(ret_scp);
  dispose_cg(cg);*/
  fprintf(stderr, "SCP not defined for Buechi containment problems.");
}

void do_containment(bool quiet) {
  CProb cp;
  Containment ret_cont;
  
	cp = parse_cp();
  ret_cont= check_containment(cp);
  if (ret_cont->result) printf("Contained\n");
  else printf("Not Contained\n");
  if ((!quiet) && (!ret_cont->result))
        report_cont_failure(ret_cont->failure_prefix, ret_cont->failure_path);
  free_containment(ret_cont);
  //dispose_cp(cp);
}

int main(argc,argv)
  int argc;
  char *argv[]; {

  long int rpts;
  bool verbose,exptmode,ptime,cln, quiet,no_sub;

  if (bool_flag("--help",argc,argv)) {
     printf("maxint: %d\n", MAXINT);
     report_usage();
     return 0;
  } 
  if (bool_flag("--crash",argc,argv)) {
    printf("In crash");
    //const char *s = "hello";
    //*s='H';
  }

  cln=		bool_flag("--cln",argc,argv);
  quiet=		bool_flag("-q",argc,argv);
  ptime= 	bool_flag("--ptime",argc,argv);
  exptmode= 	bool_flag("-e",argc,argv);
  verbose= 	bool_flag("-E",argc,argv);
  no_sub = 	bool_flag("-n",argc,argv);
  rpts= 	posi_flag("-r",argc,argv);
  subsumption = !no_sub;

  if (exptmode || verbose) { 
    //if (ptime) 
      //scp_experiment(rpts,verbose);
      fprintf(stderr,"SCP experiments not defined for Buechi containment.");
    //else 
      //sct_experiment(rpts,verbose);
  } else 
  if (ptime) 
    do_scp(quiet);
  else do_containment(quiet);
  
  fclose(stdout);
  return 0;
}

