%{
//#define YYSTYPE char *


#include <stdio.h>
#include <string.h>
#include "readCP.tab.h"


%}


/***************************************
*          
*          Grammar:
*          
*          file := { AStateList } { BStateList } { SGraphList }
*          AStateList := AState | AState AStateList
*          AState := (AID Init Accept)
*          
*          BStateList := BState | BState BStateList
*          BState := (BID Init)
*          
*          SGraphList := SGraph | SGraph SGraphList
*          SGraph := (AID AID {EdgeList})
*          
*          EdgeList := Edge | Edge EdgeList
*          Edge := (BID Accept BID) 
*          
*          AID := String
*          Init := BOOL
*          Accept := BOOL
*          
*          
******************/

%%

[a-zA-Z0-9]*            yylval.string=strdup(yytext); return STRING;
\(                      return OPAREN;
\)                      return CPAREN;
\{                      return OBRACE;
\}                      return CBRACE;
\n                      
[ \t]+                  



%%
