/***************************************
*       
*       Grammar:
*       
*       file := { AStateList } { BStateList } { SGraphList }
*       AStateList := AState | AState AStateList
*       AState := (AID Init Accept)
*       
*       BStateList := BState | BState BStateList
*       BState := (BID Init)
*       
*       SGraphList := SGraph | SGraph SGraphList
*       SGraph := (AID AID {EdgeList})
*       
*       EdgeList := Edge | Edge EdgeList
*       Edge := (BID Accept BID) 
*       
*       AID := String
*       Init := BOOL
*       Accept := BOOL
*       
*       
******************/

%{

#include <stdio.h>
#include <string.h>
#include "std.h"
#include "sgraph.h"

CProb cp;

//NodeList snodes=NULL;
//NodeList snodes1=NULL;
//NodeList dnodes=NULL;
NodeArray snodes_array;
NodeArray dnodes_array;
int graphindex=0;
SGraphList sgltmp=NULL;
SGraph sgraph=NULL;

extern int yylex(void);

 
void yyerror(const char *str)
{
      fprintf(stderr,"error: %s\n",str);
}
 
int yywrap()
{
      return 1;
} 

CProb parse_cp()
{ 
      cp = (CProb)malloc(sizeof(struct CProbRec));
      cp->astates = NULL;
      cp->bstates = NULL;
      cp->sgraphs = NULL;
      cp->bsize=0;
      //printf("Allocating nodelists.\n");
      //snodes=new_nodelist();
      //dnodes=new_nodelist();
      assert(yyparse()==0);
      //printf("Finished yyparse\n");
      //check_cp(cp);
        
      return cp;
}
  


%}

%token  OPAREN CPAREN OBRACE CBRACE

%union 
{
      int boolean;
      char *string;
}

%token <string> STRING
%type <string> aid
%type <string> bid
%type <boolean> boolval;
%type <boolean> accept;
%type <boolean> init;

%%

cproblem: OBRACE astatelist CBRACE OBRACE bstates CBRACE OBRACE sgraphlist CBRACE 
    {
        //printf("Finished cproblem:\n");
        //printf("Freeing nodelists.\n");
        free(snodes_array);
        free(dnodes_array);
        //assert_consistent_cprob(cp);
        //write_cp(cp);
        //return cp;
      }
      ;

astatelist: astate | astate astatelist
    {
      //printf("Finished astatelist\n");
    }
    ;

astate: OPAREN aid init accept CPAREN
    {
        astate_add($2, $3, $4, cp);
        //printf("Finished astate, ");
    }
    ;

bstates: bstatelist
    { 
      cp->bstates=bstates_listsort(cp->bstates);
      cp->bstate_array= array_of_bstatelist(cp->bstates,cp->bsize);
      release_bstates(cp->bstates);
      cp->bstates=list_of_bstatearray(cp->bstate_array, cp->bsize);
      //snodes=new_untied_nodes_from_array(cp->bsize,cp->bstate_array, SRC);
      //dnodes=new_untied_nodes_from_array(cp->bsize,cp->bstate_array, DST);
      snodes_array=new_node_array(cp->bsize, cp->bstate_array, SRC);
      dnodes_array=new_node_array(cp->bsize, cp->bstate_array, DST);
    } 
    ;

bstatelist: bstate | bstate bstatelist
    {
      //printf("Finished bstatelist\n");
    }
    ; 

bstate: OPAREN bid init CPAREN
    {
        bstate_add($2, $3, cp);
        //printf("Finished bstate, ");
    }
    ; 

sgraphlist: sgraph | sgraph sgraphlist
    {
      //printf("Finished sgraphlist\n");
      //we are done with adding graphs, so we don't need any more node lists.
    }
    ; 

sgraph: OPAREN aid aid edgelist CPAREN
    {
      //printf("Entering sgraph\n");
      //create and add a new supergraph
      sgraph= (SGraph)malloc(sizeof(struct SGraphRec));
      sgraph->src=astate_lookup($2, cp);
      sgraph->dst=astate_lookup($3, cp);
      sgraph->cp=cp;
      sgraph->bsize=cp->bsize;
      sgraph->src_node_array=snodes_array;
      sgraph->dst_node_array=dnodes_array;
      sgraph->index=graphindex++;
      //sgraph->_composition=NULL;
      sgraph->_in_clo_pred=NULL;
      sgraph->reachable_from_init=NULL;
      sgraph->reaching_one_scc=NULL;
      sgraph_add(sgraph, cp);
      //printf("Sgraph added\n");

    //make sure our nodes point back to us
      finish_sgraph(sgraph);
      //printf("Sgraph finished\n");
      //reset the snodes and dnodes.
      //printf("Reallocating nodelists.\n");
      //snodes=new_untied_nodes_from_array(cp->bsize,cp->bstate_array, SRC);
      //dnodes=new_untied_nodes_from_array(cp->bsize,cp->bstate_array, DST);
      snodes_array=new_node_array(cp->bsize, cp->bstate_array, SRC);
      dnodes_array=new_node_array(cp->bsize, cp->bstate_array, DST);


    //make sure our source and destination astates point back to us
      sgraph->dst->in_sgraphs=sgraph_prepend(sgraph, sgraph->dst->in_sgraphs);
      sgraph->src->out_sgraphs=sgraph_prepend(sgraph, sgraph->src->out_sgraphs);
      //printf("Leaving sgraph\n");
    }
   ; 
edgelist: OBRACE edgelistaux CBRACE | OBRACE CBRACE
   {
      //printf("Saw an edgelist\n");

    }
   ;

edgelistaux: edge | edge edgelistaux
   {
      //printf("Saw an edgelistaux\n");
    }
  ; 

edge: OPAREN bid accept bid CPAREN
   {
      Edge edgetmp;
      
      edgetmp  = (Edge)malloc(sizeof(struct EdgeRec));
      edgetmp->accept=$3;
      edgetmp->src=node_array_lookup($2, snodes_array, cp);
      edgetmp->dst=node_array_lookup($4, dnodes_array, cp);
      edgetmp->src->edges=edge_prepend(edgetmp, edgetmp->src->edges);
      edgetmp->dst->edges=edge_prepend(edgetmp, edgetmp->dst->edges);

    }
    ;

aid: STRING
   {
    $$=$1;
   }
    ;
bid: STRING
   {
    $$=$1;
   }
    ;

init: boolval
   {
    $$=$1;
   }
    ;

accept: boolval 
   {
    $$=$1;
   }
    ;

boolval: STRING
   {
      if(strcmp("1",$1)==0) {
        free($1);
        $$ = true;
      }
      else if(strcmp("0",$1)==0) {
        free($1);
        $$=false;
      }
      else {
        fprintf(stderr, "Found %s instead of a bool\n", $1);
        $$=2;
      }
   }
;
