#!/usr/bin/env perl

# Copyright (C) 2005  Laboratoire d'Informatique de Paris 6 (LIP6),
# dpartement Systmes Rpartis Coopratifs (SRC), Universit Pierre
# et Marie Curie.
#
# This file is part of Spot, a model checking library.
#
# Spot is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Spot is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
# License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Spot; see the file COPYING.  If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

use warnings;

my $line = 0;
my $tool = 0;
my ($a, $b, $acc, $time);

format STDOUT2 =
||<:>@>>||@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<||<)>@>>>>>||<)>@>>>>>||<)>@>>>||<)>@#####.##||<)>@>>>>>>>>||<)>@>>>>>>>>||<)>@>>||
$num, $tool, $a, $b, $acc, $time, $2, $3, $1
.

format STDOUT =
@>>: @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$num, $tool
       @>>>>> / @>>>>> / @>>> / @#####.##   @>>>>>>>> / @>>>>>>>>   (@>>)
$a, $b, $acc, $time, $2, $3, $1
.

$~ = STDOUT2 if (exists $ENV{'WIKI'});

my %impl;

while (<>)
{
    if (/^\s{4}(\d+):\s`(.+)'\s*(?:\(disabled\))?\s*$/)
    {
	$impl{$1} = $2 unless exists $impl{$1};
    }
    if (/Pos\. formulae \|\s*([^|]*?)\s*\|\s*([^|]*?)\s*\|$/)
    {
        $acc = $1;
	$time = $2 || 0;
    }
    next unless /Pos\. formulae \|\s*(.*?)\s*\|\s*(.*?)\s*\|\s*(.*?)\s*\|/;
    if ($line % 2)
    {
	$num = $line >> 1;
        $tool = $impl{$num};
	write;
    }
    else
    {
	($a, $b) = ($2, $3);
    }
    ++$line;
}
