// Copyright (C) 2003  Laboratoire d'Informatique de Paris 6 (LIP6),
// dpartement Systmes Rpartis Coopratifs (SRC), Universit Pierre
// et Marie Curie.
//
// This file is part of Spot, a model checking library.
//
// Spot is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spot is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
// License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spot; see the file COPYING.  If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.

#include "ltlast/atomic_prop.hh"
#include "defaultenv.hh"

namespace spot
{
  namespace ltl
  {

    default_environment::~default_environment()
    {
    }

    formula*
    default_environment::require(const std::string& s)
    {
      return atomic_prop::instance(s, *this);
    }

    const std::string&
    default_environment::name()
    {
      static std::string name("default environment");
      return name;
    }

    default_environment::default_environment()
    {
    }

    default_environment&
    default_environment::instance()
    {
      static default_environment* singleton = new default_environment();
      return *singleton;
    }

  }
}
