package dk.brics.automaton;
//import automataTools.randomX.DeianRandom;
import dk.brics.automaton.*;

public class RandomAutomaton extends Automaton {
  /*  Uses Moeller's package to create a random automaton
   *  with the given number of final states and transitions.
   */
  
  java.util.Random randy = new java.util.Random();
    
  private RandomAutomaton(int numberOfStates, int numberOfTransitions, int numberOfFinalStates) {
    /** The constructor 
    
    super();
    char[][] transitions = generateRandomTransitions(numberOfStates, numberOfTransitions);
    boolean[] finalStates = generateRandomFinalStates(numberOfStates, numberOfFinalStates);
    State[] states = defineStates(transitions, numberOfStates);
    setFinals(states, finalStates, numberOfStates);
    this.initial = states[0];
    this.deterministic = false;
    this.minimization = MINIMIZE_HUFFMAN;
    restoreInvariant();
    */
  }
  
  public RandomAutomaton(boolean[][] a_transitions, boolean [][] b_transitions, boolean[] finalStates, int algorithm) {
    /** Creates and automaton which is not random because we supply the 
     * transition matrix and the set of final states. However, we are heavily using
     * methods from RandomAutomaton, so we might as well make another constructor
     */
    super();
    //sanity check
    claim(finalStates.length == a_transitions.length, "finalStates.length == a_transitions.length " + 
	  finalStates.length +", " + a_transitions.length);
    claim(finalStates.length == a_transitions[0].length, "finalStates.length == a_transitions[0].length");
    claim(b_transitions.length == a_transitions.length, "b_transitions.length == a_transitions.length " + 
	  b_transitions.length +", " +  a_transitions.length);
    claim(b_transitions[0].length == a_transitions[0].length, "b_transitions[0].length == a_transitions[0].length");
    
    int numberOfStates = finalStates.length;
    State[] states = defineStates(a_transitions, b_transitions, numberOfStates);
    setFinals(states, finalStates, numberOfStates);
    this.initial = states[0];
    this.deterministic = false;
    this.minimization = algorithm;
    restoreInvariant();
    
  }
  /*#########################################################################*/
  
  private void claim(boolean condition, String description) {
    if (! condition) {
      System.out.println("Assertion failed: "+description+" in RandomAutomaton ");
      System.exit(4);
    }
  }
  
  /*#########################################################################*/
  
  
  private char[][] generateRandomTransitions(int numberOfStates, int numberOfTransitions) {
    /** Creates a table of random transitions */
    
    boolean[][] transitionTable = new boolean[numberOfStates][numberOfStates];
    int fromState;
    int toState;
    for (int i=0; i < numberOfTransitions; i++) {
      do {
        fromState = randy.nextInt(numberOfStates);
        toState = randy.nextInt(numberOfStates);
        //System.out.println(fromState+", "+toState);
      } while (true == transitionTable[fromState][toState]);
      transitionTable[fromState][toState] = true;
    }//for loop
    
    char[][] charTable = new char[numberOfStates][numberOfStates];
    
    for (int i=0; i<transitionTable.length; i++) {
      for (int j=0; j<transitionTable[0].length; j++) {
        if (transitionTable[i][j]) {
          //flip a coin to determine the transition symbol
          if (randy.nextBoolean())
            charTable[i][j]='a';
          else
            charTable[i][j] = 'b';
        }
        else
          charTable[i][j] = '0';
      }
    }
    
    return charTable;
  }//generateRandomTransitions
  
  /*#########################################################################*/
  
  private State[] defineStates(boolean[][] transitionTable_A, boolean[][] transitionTable_B, int numberOfStates) {
    /** Creates an array of states with the appropriate transitions between them */
    
    State[] stateArray = new State[numberOfStates];
    // Create the states
    for (int i=0; i< numberOfStates; i++)
      stateArray[i] = new State();
    
    //char transitionSymbol;
    for (int i=0; i<numberOfStates; i++) {
      for (int j=0; j<numberOfStates; j++) {
        if (transitionTable_A[i][j]) {
	    //System.out.println("Adding a-transition from "+i+" to "+j);
          stateArray[i].addTransition(new Transition('a', stateArray[j]));
        }
        if (transitionTable_B[i][j]) {
          stateArray[i].addTransition(new Transition('b', stateArray[j]));
        }
      }
    }
    
    
    return stateArray;
  }// defineStates
  
  /*#############################################################################*/
  
  private boolean[] generateRandomFinalStates(int numberOfStates, int numberOfFinalStates) {
    /** The name says it all */
    int state = -1;
    boolean[] finalStates = new boolean[numberOfStates];
    
    for (int i=0; i< numberOfFinalStates; i++) {
      do {
        state = randy.nextInt(numberOfStates);
        //System.out.println(state);
      } while (true == finalStates[state]);
      finalStates[state] = true;
    }//for
    
    return finalStates;
  }
  
  /*##############################################################################*/
  
  private void setFinals(State[] stateArray, boolean[] finalStates, int numberOfStates) {
    /** Marks the appropriate states from the array as final */
    
    for (int i=0; i< numberOfStates; i++) {
      if (true == finalStates[i])
        stateArray[i].setAccept(true);
    }
  }
  
  /*##############################################################################*/
  
}
