package dk.extra;
import dk.brics.automaton.*;
import java.util.*;
import java.io.*;
import java.text.DecimalFormat;

public abstract class ADataParser implements IDataParser {
    
    DecimalFormat rFormatter = new DecimalFormat("0.00");
    DecimalFormat fFormatter = new DecimalFormat("0.00");
    
    public static final int TIMEOUT_FLAG = -666;
    public static final double TIMEOUT_VALUE = 1000000000;
    public static final int TIMEOUT_INT_VALUE = 1000000000;

    abstract public void printMyName();
    
    /** For a fixed size, calculate the median for all measurables as a function of the
     * transition and final state density
     */
    public void parseScalingData(ArrayList rdensity, ArrayList fdensity, ArrayList sizeArray,
				 File sourceDir, File output, int expectedCount) {
	
	double rLow = ( (Double) rdensity.get(0) ).doubleValue();
	double rHigh = ( (Double) rdensity.get(rdensity.size()-1) ).doubleValue();
    
	double fLow = ( (Double) fdensity.get(0) ).doubleValue();
	double fHigh = ( (Double) fdensity.get(fdensity.size()-1) ).doubleValue();
    
	int sLow = ( (Integer) sizeArray.get(0) ).intValue();
	int sHigh = ( (Integer) sizeArray.get(sizeArray.size()-1) ).intValue();
    
    
	for (int rIndex=0; rIndex<rdensity.size(); rIndex++) {
	    for (int fIndex=0; fIndex<fdensity.size(); fIndex++) {
		
		double currentR = ( (Double) rdensity.get(rIndex) ).doubleValue();
		double currentF = ( (Double) fdensity.get(fIndex) ).doubleValue();
        
		String affix = "-scaling-s-"+sLow+"--"+sHigh+"-r-"+currentR+"-f-"+currentF;
		PrintWriter[] allFiles = defineOutputFiles(output, "", affix);
		
		for (int sIndex = 0; sIndex < sizeArray.size(); sIndex ++) {
		    
		    int currentS = ( (Integer) sizeArray.get(sIndex)).intValue();
		    File currentDirectory = sourceDir;
		    
		    if (rFormatter == null) 
			throw new AssertionError("rFormatter should not be null in ADataParser");
		    if (fFormatter == null)
			throw new AssertionError("fFormatter should not be null in ADataParser");

		    // Pull out the list of files that match the current (r,f,s) criteria
		    FilenameFilter criteria = Utils.nameContains(currentS, currentR, rFormatter, currentF, fFormatter);
		    File[] groupFiles = currentDirectory.listFiles(criteria);
		    
		    // Consistency check: numAutomata should match the file name signature!
		    if (groupFiles.length==0) {
			for (int i=0; i<20; i++)
			    System.out.println("Error! Error! Error!");
			
			System.err.println("For the "+currentR+", "+currentF + " pair there are no input files! Exiting now!!");
			//System.exit(11);
		    }
		    else {

			if (groupFiles.length != expectedCount) {
			    System.err.println("For the "+currentR+", "+currentF + 
					       " pair there is a mismatch between the count of the files (" 
					       + groupFiles.length + ") and the expected count (" 
					       + expectedCount +")! I am not exiting, though!");
			    //System.exit(12);
			}
			
			// Process the files in this group, extracting the data and filling out the appropriate arrays
			System.out.println("Parsing into arrays automata with parameters "
					   +currentR + ", "+currentF + ", "+ currentS+".");
			
			parseIntoArrays(groupFiles);
          
          
			printDataToFiles();
		    }
		}//for all sizes
		for (int i=0; i<allFiles.length; i++) {
		    allFiles[i].println(";");
		    allFiles[i].close();
		}
        
        
	    }//for over all f densities
	}//for over all r
    
    } // end of piece for processor 0;
  
  
  
  
  
    /* We can also fix the size, and look at the landscape for changing r and f densities 
     * double rLow, rHigh -- transition density (in ArrayList rDensity)
     * double fLow, fHigh - final state count/density (in ArrayList fDensity)
     * double sLow, sHigh - size range (in ArrayList sizeArray)
     */
    public void parseLandscapeData(ArrayList rdensity, ArrayList fdensity, ArrayList sizeArray,
				   File sourceDir, File output, int expectedCount) { 
    
	double rLow = ( (Double) rdensity.get(0) ).doubleValue();
	double rHigh = ( (Double) rdensity.get(rdensity.size()-1) ).doubleValue();
    
	double fLow = ( (Double) fdensity.get(0) ).doubleValue();
	double fHigh = ( (Double) fdensity.get(fdensity.size()-1) ).doubleValue();
    
	int sLow = ( (Integer) sizeArray.get(0) ).intValue();
	int sHigh = ( (Integer) sizeArray.get(sizeArray.size()-1) ).intValue();
    
	//System.out.println("Processor 1 starting his piece");
	for (int sizeIndex = 0; sizeIndex < sizeArray.size(); sizeIndex++) {
	    int currentSize = ( (Integer) sizeArray.get(sizeIndex)).intValue();
	    System.out.println("Starting size " + currentSize);
      
	    String fileNamePrefix = ""+currentSize+"-landscape-r-"+rLow+"--"+rHigh+"-f-"+fLow+"--"+fHigh+"---";
	    PrintWriter[] allFiles = defineOutputFiles(output, fileNamePrefix, "");
      
	    for (int rIndex=0; rIndex<rdensity.size(); rIndex++) {
		for (int fIndex=0; fIndex<fdensity.size(); fIndex++) {
          
		    double currentR = ( (Double) rdensity.get(rIndex) ).doubleValue();
		    double currentF = ( (Double) fdensity.get(fIndex) ).doubleValue();
		    
		    if (rFormatter == null) 
			throw new AssertionError("rFormatter should not be null in ADataParser");
		    if (fFormatter == null)
			throw new AssertionError("fFormatter should not be null in ADataParser");

		    File[] groupFiles = sourceDir.listFiles(Utils.nameContains(currentSize, currentR, rFormatter, currentF, fFormatter));
		    
		    System.out.println("Parsing into arrays these "+
				       groupFiles.length + " automata with parameters "
				       +currentR + ", "+currentF + ", "+ currentSize+".");
		    

		    // Consistency check: numAutomata should match the file name signature!
		    if (groupFiles.length==0) {
			for (int i=0; i<20; i++)
			    System.out.println("Error! Error! Error!");
			System.err.println("For the "+currentR+", "+currentF + " pair there are no input files! Exiting now");
			//System.exit(11);
		    }
		    else {

			if (groupFiles.length != expectedCount) {
			    System.err.println("For the "+currentR+", "+currentF + 
					       " pair there is a mismatch between the count of the files (" 
					       + groupFiles.length + ") and the expected count (" 
					       + expectedCount +")! I am not exiting, though!");
			    //System.exit(12);
			}

		    
			parseIntoArrays(groupFiles);
			
			printDataToFiles();
		    }
          
		}//loop over f
        
		// new line for each new r density
		for (int i=0; i<allFiles.length; i++)
		    allFiles[i].println();
        
	    }//loop over r
      
	    // close everything for this size
	    for (int i=0; i<allFiles.length; i++) 
		allFiles[i].close();
      
      
      
	}//loop over size      
    } //end of piece for processor 1;
  
  
    
    /**
     * Allows the user to change the format of the final states as
     * they appear in the file name. This is necessary because we used
     * to have linear density of the final states, and a fixed-number
     * distribution.
     */
    public void setFinalStateFormatter(DecimalFormat newFformatter) {
	fFormatter = newFformatter;
    }
    
    
    /** 
     * Prints all data to the files 
     */
    abstract void printDataToFiles();





    /**
     * Parses all files in @groupFiles and adds the data to the
     * appropriate arrays.
     */
    abstract void parseIntoArrays(File[] groupFiles);



    /**
     * Creates the output files and returns an array that contains
     * them all. We use this array later on to write semicolons and
     * newlines to each output file as necessary, in a loop.
     */
    abstract PrintWriter[] defineOutputFiles(File outputDir, String prefix, String affix);
}
