package dk.extra;
import dk.brics.automaton.*;
import java.util.*;
import java.io.*;
import java.text.DecimalFormat;

public abstract class BasicSMVParser extends ADataParser {
  
    /* Make these arrays visible everywhere, to avoid passing them down as arguments*/
    double[] a_complementTime;
    double[] a_userTime;
    double[] a_systemTime;
    double[] a_heuristicTime;
    
    LinkedList uniTime = new LinkedList();
    LinkedList nuniTime = new LinkedList();
  
    UniversalRatio ur;

    int automataPerGroup;
  
    int[] a_allocNodes;
  
    PrintWriter f_complementTime, f_userTime, f_systemTime, 
	f_heuristicTime, f_allocNodes, f_complementTimeAve, f_universal,
	f_uniComplementTime, f_nuniComplementTime, f_minmax, 
	f_listUniCompTime, f_listNuniCompTime, f_listAllCompTime,
	f_stdevDetTime, f_allData;
  
    PrintWriter[] allFiles;
  
  
    double minUniTime = 1e6;
    double maxUniTime = -1;
    String minTimeUniAutomaton = "";
    String maxTimeUniAutomaton = "";
    
    double minNuniTime = 1e6;
    double maxNuniTime = -1;
    String minTimeNuniAutomaton = "";
    String maxTimeNuniAutomaton = "";
  
  
    DecimalFormat rFormatter = new DecimalFormat("0.00");
    DecimalFormat fFormatter = new DecimalFormat("0.00"); //default value, may be changed by caller, see main()
  
    int numUnivAut;
  
    abstract public void printMyName();
    abstract IFileParser makeParser(File file);
  
  
    /** Gives actual values to the (globally declared) output files based on the 
     * prefix/affix string, and the output directory).
     */ 
    public PrintWriter[] defineOutputFiles(File output, String prefix, String affix) {
	try {
	    f_complementTime = new PrintWriter(new FileWriter(new File(output, prefix + "complementTime" + affix)));
	    f_heuristicTime = new PrintWriter(new FileWriter(new File(output, prefix + "heuristicTime" + affix)));
	    f_userTime = new PrintWriter(new FileWriter(new File(output, prefix + "userTime" + affix)));
	    f_systemTime = new PrintWriter(new FileWriter(new File(output, prefix + "systemTime" + affix)));
	    f_allocNodes = new PrintWriter(new FileWriter(new File(output, prefix + "allocNodes" + affix)));
	    f_complementTimeAve = new PrintWriter(new FileWriter(new File(output, prefix + "averageComplementTime" + affix)));
	    f_universal = new PrintWriter(new FileWriter(new File(output, prefix + "universal" + affix)));
	    f_uniComplementTime = new PrintWriter(new FileWriter(new File(output, prefix + "uniComplementTime" + affix)));
	    f_nuniComplementTime = new PrintWriter(new FileWriter(new File(output, prefix + "nuniComplementTime" + affix)));
	    f_minmax = new PrintWriter(new FileWriter(new File(output, prefix + "minMaxTime" + affix)));
	    f_listUniCompTime = new PrintWriter(new FileWriter(new File(output, prefix + "listUniCompTime" + affix)));
	    f_listNuniCompTime = new PrintWriter(new FileWriter(new File(output, prefix + "listNuniCompTime" + affix)));
	    f_listAllCompTime = new PrintWriter(new FileWriter(new File(output, prefix + "listAllCompTime" + affix)));


	    // Emit the arrays themselves, for manual parsing of the data for those who are interested
	    f_allData = new PrintWriter(new FileWriter(new File(output, prefix + "allData" + affix)));
	    
	    f_stdevDetTime =  new PrintWriter(new FileWriter(new File(output, prefix + "standarddevDetTime" + affix)));
	    
	}
	catch(IOException e) {
	    System.out.println("Error creating the output files "+e);
	    System.exit(2223);
	}
    
	return new PrintWriter[] {f_complementTime, f_heuristicTime, f_userTime, f_systemTime, f_allocNodes, f_universal, 
				  f_uniComplementTime, f_nuniComplementTime, f_complementTimeAve, f_minmax, f_listUniCompTime, f_listNuniCompTime,
				  f_listAllCompTime, f_allData, f_stdevDetTime};
    }
  




    /** 
     * Prints all data to the files 
     */
    void printDataToFiles() {
    
	DecimalFormat form = new DecimalFormat("0.000");
	// Aggregate analysis. Print the data for this size and move on. 
    
	
	// AllData 
	//
	//For the time being, only record the detTime and prunedSize,
	//which really corresponds to the time it takes to determine
	//whether the automaton is universal or not, and the size of
	//the automaton after we remove the unreachable states..
	f_allData.print("Actual Num Automata: " + automataPerGroup + "\n Universality Check\nUser Time: [");
	for (int i=0; i<automataPerGroup; i++) {
	    f_allData.print("" + a_userTime[i] + ((i==automataPerGroup-1)?"]\n":", "));
	}

	f_allData.print("Universality Check\nSystem time: [");
	for (int i=0; i<automataPerGroup; i++) {
	    f_allData.print("" + a_systemTime[i] + ((i==automataPerGroup-1)?"]\n":", "));
	}

	f_allData.print("Universality Check\nTotal time: [");
	for (int i=0; i<automataPerGroup; i++) {
	    f_allData.print("" + a_complementTime[i] + ((i==automataPerGroup-1)?"]\n":", "));
	}
	
	f_stdevDetTime.print(" "+form.format(Utils.getStandardDeviation(a_complementTime, automataPerGroup)));
	
	//System.out.println("Printing data to files. AutomataPerGroup="automataperGroup);
	
	f_complementTime.print(" "+form.format(Utils.getMedian(a_complementTime, automataPerGroup)));
	f_userTime.print(" "+form.format(Utils.getMedian(a_userTime, automataPerGroup)));
	f_systemTime.print(" "+form.format(Utils.getMedian(a_systemTime, automataPerGroup)));
	f_complementTimeAve.print(" "+form.format(Utils.getMean(a_complementTime, automataPerGroup))); // <<--- Mean!
	f_allocNodes.print(" " + form.format(Utils.getMedian(a_allocNodes, automataPerGroup)));
	f_heuristicTime.print(" " + form.format(Utils.getMedian(a_heuristicTime, automataPerGroup)));
	f_universal.print(" " + ur.getNumUniversal() + "/" + ur.getNumAll());
	



	/* Deal with the arrays of segregated time data for universal and non-iniversal automata. */
	Object[] uni = uniTime.toArray();
	Object[] nuni = nuniTime.toArray();
	System.out.println(""+uni.length + " + " + nuni.length + " = " + automataPerGroup);
	Utils.affirm(uni.length + nuni.length == ur.getNumAll(), "Uni+nuni=automataPerGroup");
    
	double[] a_uni = new double[uni.length];
	double[] a_nuni = new double[nuni.length];
    
	for (int i=0; i<uni.length; i++)
	    a_uni[i] = ((Double) uni[i]).doubleValue();
    
	for (int i=0; i<nuni.length; i++)
	    a_nuni[i] = ((Double) nuni[i]).doubleValue();
    
	if (a_uni.length == 0)
	    f_uniComplementTime.print("-1");
	else
	    f_uniComplementTime.print(" " + form.format(Utils.getMedian(a_uni, a_uni.length)));
    
	if (a_nuni.length == 0)
	    f_nuniComplementTime.print("-1");
	else
	    f_nuniComplementTime.print(" " + form.format(Utils.getMedian(a_nuni, a_nuni.length)));
    
	String forMinMax = "\nUniversal Automata\n";
	forMinMax += minTimeUniAutomaton + " --->> " + minUniTime + '\n';
	forMinMax += maxTimeUniAutomaton + " --->> " + maxUniTime + '\n';
	forMinMax += "Non-universal Automata\n";
	forMinMax += minTimeNuniAutomaton + " --->> " + minNuniTime + '\n';
	forMinMax += maxTimeNuniAutomaton + " --->> " + maxNuniTime + '\n';
	f_minmax.print(forMinMax);
    
	/* Populate the list files for uni and nuni automata */
	String forListUniCompTime = "";
	for (int i=0; i<a_uni.length; i++)
	    forListUniCompTime += (""+a_uni[i] + '\n');
    
	String forListNuniCompTime = "";
	for (int i=0; i<a_nuni.length; i++)
	    forListNuniCompTime += (""+a_nuni[i] + '\n');
    
    
	f_listUniCompTime.print(forMinMax);
	f_listUniCompTime.print(forListUniCompTime);
    
	f_listNuniCompTime.print(forMinMax);
	f_listNuniCompTime.print(forListNuniCompTime);
    
	/* Also create the array with total time (system + user) and
	 * write it to its own list file.
	 */
	String forListAll = "";
	for (int i=0; i<a_complementTime.length; i++) { 
	    forListAll += (""+a_complementTime[i] + '\n');
	}
	f_listAllCompTime.print(forMinMax);
	f_listAllCompTime.print(forListAll);
    
    }
  
  
  
  
  
  
  
  
  
    /**
     * Uses the specifics about the Cadence format to extract the data
     * from the results filex
     */

    void parseIntoArrays(File[] groupFiles) {
	
	f_allData.print(groupFiles[0].getName());

	
	int numAutomata = groupFiles.length; //previously checked to match numAutomata from the file name
	automataPerGroup = numAutomata;
	ur = new UniversalRatio();

	System.out.println("Parsing "+groupFiles.length + " automata into arrays");
    
	a_complementTime = new double[numAutomata];
	a_userTime = new double[numAutomata];
	a_systemTime = new double[numAutomata];
	a_allocNodes = new int[numAutomata];
	a_heuristicTime = new double[numAutomata];
	uniTime = new LinkedList();
	nuniTime = new LinkedList();
    
	minUniTime = 1e6;
	maxUniTime = -1;
	minTimeUniAutomaton = "";
	maxTimeUniAutomaton = "";
    
	minNuniTime = 1e6;
	maxNuniTime = -1;
	minTimeNuniAutomaton = "";
	maxTimeNuniAutomaton = "";
    
	int valid_automata_counter = 0; // Count number of automata that parse cleanly
	for (int i=0; i<numAutomata; i++)  {
	    //System.out.println("Parsing " + groupFiles[i]);
	    if (groupFiles[i] == null) {
		automataPerGroup = i-1;
		System.err.println("Note that the number of automata in this group is "+automataPerGroup+" while expected number was "+numAutomata);
		break;
	    }
      
	    IFileParser parser = makeParser(groupFiles[i]);
	    int parse_return = parser.parse();

	    if (parse_return == 0) {
		double totalTime = parser.getUserTime() + parser.getSystemTime();
      
		a_complementTime[valid_automata_counter] = totalTime;
		a_userTime[valid_automata_counter] = parser.getUserTime();
		a_systemTime[valid_automata_counter] = parser.getSystemTime();
		a_allocNodes[valid_automata_counter] = parser.getNodes();
		a_heuristicTime[valid_automata_counter] = parser.getHeuristicTime();
		
		Double exeTime = new Double(totalTime);
		if (parser.isUniversal()) {
		    uniTime.add(exeTime);
		    ur.incrementUniversal();
		}
		else
		    nuniTime.add(exeTime);
      
		//Determine the max and the min universal automaton
		if (parser.isUniversal()) {
		    if (totalTime > maxUniTime) {
			maxUniTime = totalTime;
			maxTimeUniAutomaton = groupFiles[valid_automata_counter].toString();
		    }
      
		    if (totalTime < minUniTime) {
			minUniTime = totalTime;
			minTimeUniAutomaton = groupFiles[valid_automata_counter].toString();
		    }
		}
      
		if (! parser.isUniversal()) {
		    //Determine the max and the min non-universal automaton
		    if (totalTime > maxNuniTime) {
			maxNuniTime = totalTime;
			maxTimeNuniAutomaton = groupFiles[valid_automata_counter].toString();
		    }
      
		    if (totalTime < minNuniTime) {
			minNuniTime = totalTime;
			minTimeNuniAutomaton = groupFiles[valid_automata_counter].toString();
		    }
		}


		valid_automata_counter ++;
		ur.incrementCount();
	    } // end if file parsed correctly

	    else {
		System.err.println("Error parsing the file " + groupFiles[i]);
		System.err.println("Setting the TIMEOUT values!");

		a_complementTime[valid_automata_counter] = ADataParser.TIMEOUT_VALUE;
		a_userTime[valid_automata_counter] = ADataParser.TIMEOUT_VALUE;
		a_systemTime[valid_automata_counter] = ADataParser.TIMEOUT_VALUE;
		a_allocNodes[valid_automata_counter] = ADataParser.TIMEOUT_INT_VALUE;
		a_heuristicTime[valid_automata_counter] = ADataParser.TIMEOUT_VALUE;

		valid_automata_counter ++;
	    }
          
	} //for all automata in this group

	automataPerGroup = valid_automata_counter;
	if (numAutomata != valid_automata_counter) {
	    System.err.println("In this group: files matching the signature: " + numAutomata);
	    System.err.println("Files that parsed correctly: " + valid_automata_counter);
	    System.err.println("Number of datapoints (used for aggregate statistics): "+automataPerGroup);
	}

    
    }//parseIntoArrays
}
