package dk.extra;
import java.text.DecimalFormat;


/**
 * An interface for all Wrappers defined below. 
 */
interface IDataWrapper {
    String toString(DecimalFormat form);
    int compareTo(Object o);
}



/**
 * A wrapper for data of type int
 */
class IntWrapper implements IDataWrapper {
    
    private int _value;

    /**
     * The constructor
     */
    public IntWrapper(int v) {
	_value = v;
    }


    /**
     * Prints the stored value discarding the format (which is for
     * data of type double)
     */
    public String toString(DecimalFormat form) {
	return new Integer(_value).toString();
    }

    
    
    /**
     * Assumes that the passed object is of the same type. Returns -1
     * if I am smaller, and 1 if I am bigger. 0 if I am equal.
     */
    public int compareTo(Object o) {
	IntWrapper i = (IntWrapper) o;
	int i_value = i.getValue();


	if (_value < i_value)
	    return -1;
	else if (_value == i_value)
	    return 0;
	else
	    return 1;
    }

    

    /**
     * Returns the stored value.
     */
    public int getValue() {
	return _value;
    }
   
}




/**
 * A wrapper for data of type double
 */
class DoubleWrapper implements IDataWrapper {
    
    private double _value;

    /**
     * The constructor
     */
    public DoubleWrapper(double v) {
	_value = v;
    }


    /**
     * Prints the stored value discarding the format (which is for
     * data of type double)
     */
    public String toString(DecimalFormat form) {
	return "" + form.format(_value);
    }

    
    
    /**
     * Assumes that the passed object is of the same type. Returns -1
     * if I am smaller, and 1 if I am bigger. 0 if I am equal.
     */
    public int compareTo(Object o) {
	DoubleWrapper d = (DoubleWrapper) o;
	double d_value = d.getValue();


	if (_value < d_value)
	    return -1;
	else if (_value == d_value)
	    return 0;
	else
	    return 1;
    }

    

    /**
     * Returns the stored value.
     */
    public double getValue() {
	return _value;
    }
   
}



/**
 * Used for easy calculation of the universal ratio in automata
 * complementation
 */
class UniversalRatio {

    private int _numAll;
    private int _numUniversal;


    /**
     * The constructor
     */
    public UniversalRatio() {
	_numAll = 0;
	_numUniversal = 0;
    }

    
    public void incrementCount() {
	_numAll++;
    }

    public void incrementUniversal() {
	_numUniversal++;
    }


    public int getNumUniversal() {
	return _numUniversal;
    }

    public int getNumAll() {
	return _numAll;
    }
}
