package dk.extra;

/**
 * A data structure to hold information about measured time while
 * parsing data. Created 8/28/05.
 */
public class MeasuredTime {
    private double _userTime;
    private double _systemTime;
    private double _toolTime;
    private double _totalTime; // usually unused
    private boolean _totalTimeSet; // Whether the user has set the total time.
    private boolean _timeout; // Whether we timed out
    
    public static final double VERY_LONG_TIME = 666666.6;
    
    
    /**
     * The constructor 
     */
    public MeasuredTime() {
	_userTime = 0;
	_systemTime = 0;
	_toolTime = 0;
	_totalTime = 0;
	_totalTimeSet = false;
	_timeout = false;
    }

    /**
     * Explicitly resets all data to 0
     */
    public void bzero() {
	_userTime = 0;
	_systemTime = 0;
	_toolTime = 0;
	_totalTime = 0;
	_totalTimeSet = false;
	_timeout = false;
    }

    /**
     * The standard setters
     */
    public void setUserTime(double u) {
	_userTime = u;
    }

    public void setSystemTime(double s) {
	_systemTime = s;
    }

    public void setToolTime(double t) {
	_toolTime = t;
    }

    public void setTotalTime(double tt) {
	_totalTime = tt;
	_totalTimeSet = true;
    }

    public void setTimeout(boolean b) {
	_timeout = b;
    }
    
    /**
     * The standard getters
     */
    public double getUserTime() {
	if (_timeout)
	    return MeasuredTime.VERY_LONG_TIME;
	else
	    return _userTime;
    }

    public double getSystemTime() {
	if (_timeout)
	    return MeasuredTime.VERY_LONG_TIME;
	else
	    return _systemTime;
    }

    public double getTotalTime() {
	if (_timeout)
	    return MeasuredTime.VERY_LONG_TIME;
	else if (_totalTimeSet)
	    return _totalTime;
	else
	    return _userTime + _systemTime;
    }

    public double getToolTime() {
	if (_timeout)
	    return MeasuredTime.VERY_LONG_TIME;
	else
	    return _toolTime;
    }

    public boolean getTimeout() {
	return _timeout;
    }
}


/**
 * An object to represent the MeasuredTime objects for which we have a timeout.
 */
class MeasuredTimeTimeout extends MeasuredTime {

    // Singleton pattern
    public static final MeasuredTimeTimeout Singleton = new MeasuredTimeTimeout();
    
    private MeasuredTimeTimeout() {}
    
    public double getUserTime() {
	throw new AssertionError("You shouldn't be using this method on a Timeout MeasuredTIme object!");
    }
    
    public double getSystemTime() {
	throw new AssertionError("You shouldn't be using this method on a Timeout MeasuredTIme object!");
    }

    public double getTotalTime() {
	throw new AssertionError("You shouldn't be using this method on a Timeout MeasuredTIme object!");
    }

    public double getToolTime() {
	throw new AssertionError("You shouldn't be using this method on a Timeout MeasuredTIme object!");
    }

    public boolean getTimeout() {
	return true;
    }
}
