package dk.extra;
import dk.extra.Utils;
import java.io.*;
import java.util.*;
import java.text.DecimalFormat;



public class MultiDataParser extends ADataParser {
  
    private DecimalFormat rFormatter = new DecimalFormat("0.00");
    private DecimalFormat fFormatter = new DecimalFormat("0.00"); //default value, may be changed by caller, see main()
  
  
    /* Make these arrays visible everywhere, to avoid passing them down as arguments*/
    // Timing data
    private  int[]     a_detTime;
    private  int[] a_unicheckTime;
    private  int[]      a_minTime;
  
    // Size data
    private  int[] a_prunedSize;
    private  int[]    a_detSize;
    private  int[]    a_minSize;
  
    // Memory data
    private long[] a_totalMem;
    private long[] a_initiallyfreeMem;
    private long[] a_afterdetMem;
    private long[] a_afterunicheckMem;
    private long[] a_afterminMem;
    private long[] a_finallyfreeMem;

    // Universality vector
    private boolean[] a_universality;
  
  
    /* Globally visible names of the output files */
    PrintWriter f_detTime, f_unicheckTime, f_minTime, f_prunedSize,
	f_detSize, f_minSize, f_totalMem, f_initiallyfreeMem,
	f_afterdetMem, f_afterunicheckMem, f_afterminMem, f_finallyfreeMem,
	f_universalAutomata, f_averageDetTime, f_stdevDetTime, f_allData,
	f_averageMinSize;
  
    int actualNumAutomata;
  
    PrintWriter[] allFiles;
    private  int numUnivAut;
  
    public void setFinalStateFormatter(DecimalFormat newFformatter) {
	fFormatter = newFformatter;
    }
  
    public static void main(String[] args) {
	ParsingDriver driver = new ParsingDriver(new MultiDataParser());
	driver.theMain(args);
    }
  
  
  
    /** Just a signature so that we know we have been working with the right parser */
    public void printMyName() {
	System.out.println("This is the multi data parser!");
    }
  
  
  
  
    /** 
     * Extracts the data from the datafiles and puts it in the
     * appropriate arrays.
     */
    public  void parseIntoArrays(File[] groupFiles) {
	numUnivAut = 0;
	
	int expectedNumAutomata = groupFiles.length; //previously checked to match expectedNumAutomata from the file name
	//Note that we may choose to ignore mismatches so that we can handle missing date when only a few files are missing.
	f_allData.println("Starting to parse into arrays these " + expectedNumAutomata + " files");
	actualNumAutomata = expectedNumAutomata;
    
	// Timing data
	a_detTime = new int[expectedNumAutomata];
	a_unicheckTime = new int[expectedNumAutomata];
	a_minTime = new int[expectedNumAutomata];
    
	// Size data
	a_prunedSize = new int[expectedNumAutomata];
	a_detSize = new int[expectedNumAutomata];
	a_minSize = new int[expectedNumAutomata];
    
	// Memory data
	a_totalMem = new long[expectedNumAutomata];
	a_initiallyfreeMem = new long[expectedNumAutomata];
	a_afterdetMem = new long[expectedNumAutomata];
	a_afterunicheckMem = new long[expectedNumAutomata];
	a_afterminMem = new long[expectedNumAutomata];
	a_finallyfreeMem = new long[expectedNumAutomata];

	// Universality vector
	a_universality = new boolean[expectedNumAutomata];
    
	for (int i=0; i < expectedNumAutomata; i++)  {
      
	    if (groupFiles[i]==null) {
		actualNumAutomata = i-1;
		System.err.println("Note that the actual number of automata is "+actualNumAutomata + 
				   " while the expected number is "+expectedNumAutomata);
		break;
	    }
        
	    String[] inputLines = new String[200];
	    try {
		BufferedReader in = new BufferedReader ( new FileReader (groupFiles[i]));
		String s;
		boolean[] parsedData = new boolean[13]; // 12 + 1
		for (int j=0; j< parsedData.length; j++)
		    parsedData[j] = false;
        
     
		// Count number of total automata
		while ( (s=in.readLine()) != null) {
		    if (s.indexOf("Total:") > -1) {
			parsedData[0] = true;
			int boolBeginsAt = s.indexOf(": ")+2;
			boolean universalAutomaton = Boolean.valueOf(s.substring(boolBeginsAt)).booleanValue();
			if (universalAutomaton) {
			    a_universality[i] = true;
			    numUnivAut++;
			}
			else {
			    a_universality[i] = false;
			}
		    }
          
		    //Determinize Time:
		    else if (s.indexOf("Determinize Time") > -1) {
			parsedData[1] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_detTime[i] = Integer.parseInt(s.substring(intBeginsAt));
		    }
          
		    //Universality Check Time
		    else if (s.indexOf("Uni Check Time") > -1) {
			parsedData[2] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_unicheckTime[i] = Integer.parseInt(s.substring(intBeginsAt));
		    }
          
		    //Minimize Time
		    else if (s.indexOf("Minimize Time") > -1) {
			parsedData[3] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_minTime[i] = Integer.parseInt(s.substring(intBeginsAt));
		    }
          
		    //Pruned Size
		    else if (s.indexOf("Pruned Size") > -1) {
			parsedData[4] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_prunedSize[i] = Integer.parseInt(s.substring(intBeginsAt));
		    }
          
		    //Determinized Size
		    else if (s.indexOf("Determinized Size") > -1) {
			parsedData[5] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_detSize[i] = Integer.parseInt(s.substring(intBeginsAt));
		    }
          
		    //Minimized Size
		    else if (s.indexOf("Minimized Size") > -1) {
			parsedData[6] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_minSize[i] = Integer.parseInt(s.substring(intBeginsAt));
		    }
          
		    //Total Available Memory
		    else if (s.indexOf("Total memory") > -1) {
			parsedData[7] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_totalMem[i] = Long.parseLong(s.substring(intBeginsAt));
		    }
          
		    //Initially free memory
		    else if (s.indexOf("Initially free memory") > -1) {
			parsedData[8] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_initiallyfreeMem[i] = Long.parseLong(s.substring(intBeginsAt));
		    }    
          
		    //After unicheck free memory
		    else if (s.indexOf("After determinize free memory") > -1) {
			parsedData[9] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_afterdetMem[i] = Long.parseLong(s.substring(intBeginsAt));
		    }            
          
		    //After unicheck free memory
		    else if (s.indexOf("After unicheck free memory") > -1) {
			parsedData[10] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_afterunicheckMem[i] = Long.parseLong(s.substring(intBeginsAt));
		    }            
          
		    //After minimize free memory
		    else if (s.indexOf("After minimize free memory") > -1) {
			parsedData[11] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_afterminMem[i] = Long.parseLong(s.substring(intBeginsAt));
		    }    
                    
		    //Initially free memory
		    else if (s.indexOf("Finally free memory") > -1) {
			parsedData[12] = true;
			int intBeginsAt = s.indexOf(": ")+2;
			a_finallyfreeMem[i] = Long.parseLong(s.substring(intBeginsAt));
		    }   
          
		} //while
		in.close();
        
		
		for (int j=0; j<parsedData.length; j++) {
		    if (! parsedData[j]) {
			System.err.println("Didn't parse data item " + j + " from file \n" + groupFiles[i].getName());
			System.exit(123);
		    }
		}
		
	    }
	    catch (IOException f) {
		System.out.println(f.toString());
	    }
	    
      
	}// for all automata in this group
	

	// This is really smart: annotate the raw dump at parse time,
	// because later we don't have information about the
	// parameters that this dump refers to, but they are
	// conveniently in the file name.
	f_allData.println(groupFiles[0].getName());
	
	//System.out.println("Parsing into arrays done. The size of a_resultingSize is "+a_resultingSize.length);
    }//parseIntoArrays
  
    






    /** 
     * Gives actual values to the (globally declared) output files
     * based on the prefix/affix string, and the output directory).
     */ 
    public  PrintWriter[] defineOutputFiles(File output, String prefix, String affix) {
	try {
	    f_detTime = new PrintWriter(new FileWriter(new File(output, prefix + "detTime" + affix)));
	    f_unicheckTime = new PrintWriter(new FileWriter(new File(output, prefix + "unicheckTime" + affix))); 
	    f_minTime = new PrintWriter(new FileWriter(new File(output, prefix + "minTime" + affix))); 
	    f_prunedSize = new PrintWriter(new FileWriter(new File(output, prefix + "prunedSize" + affix)));
	    f_detSize = new PrintWriter(new FileWriter(new File(output, prefix + "detSize" + affix))); 
	    f_minSize = new PrintWriter(new FileWriter(new File(output, prefix + "minSize" + affix))); 
	    f_totalMem = new PrintWriter(new FileWriter(new File(output, prefix + "totalMem" + affix))); 
	    f_initiallyfreeMem = new PrintWriter(new FileWriter(new File(output, prefix + "initiallyfreeMem" + affix)));
	    f_afterdetMem = new PrintWriter(new FileWriter(new File(output, prefix + "afterdetMem" + affix)));
	    f_afterunicheckMem = new PrintWriter(new FileWriter(new File(output, prefix + "afterunicheckMem" + affix))); 
	    f_afterminMem = new PrintWriter(new FileWriter(new File(output, prefix + "afterminMem" + affix))); 
	    f_finallyfreeMem = new PrintWriter(new FileWriter(new File(output, prefix + "finallyfreeMem" + affix)));
	    f_averageDetTime = new PrintWriter(new FileWriter(new File(output, prefix + "averageDetTime" + affix)));
	    f_stdevDetTime =  new PrintWriter(new FileWriter(new File(output, prefix + "standarddevDetTime" + affix)));
	    f_averageMinSize =  new PrintWriter(new FileWriter(new File(output, prefix + "aveMinSize" + affix)));

	    // Notice that we manipulate this file manually, so we don't return it with the others in the array of files
	    // Actually, notice that we DO return it with the others...
	    f_allData = new PrintWriter(new FileWriter(new File(output, prefix + "allData" + affix)));

	    f_universalAutomata = new PrintWriter(new FileWriter(new File(output, prefix + "universalAutomata" + affix)));
	}
	catch(IOException e) {
	    System.out.println("Error creating the output files "+e);
	    System.exit(2223);
	}
    
	return new PrintWriter[] {f_detTime, f_unicheckTime, f_minTime, f_prunedSize,
				  f_detSize, f_minSize, f_totalMem, f_initiallyfreeMem,
				  f_afterdetMem, f_afterunicheckMem, f_afterminMem, f_finallyfreeMem, 
				  f_universalAutomata, f_averageDetTime, f_stdevDetTime, f_allData,
				  f_averageMinSize};
    }
  
  
    public  void printDataToFiles() {
      
	DecimalFormat form = new DecimalFormat("0.00");
    
	f_universalAutomata.print(" " + numUnivAut);

	// AllData 
	//
	//For the time being, only record the detTime and prunedSize,
	//which really corresponds to the time it takes to determine
	//whether the automaton is universal or not, and the size of
	//the automaton after we remove the unreachable states..
	f_allData.print("Actual Num Automata: " + actualNumAutomata + "\n detTime: [");
	for (int i=0; i<actualNumAutomata; i++) {
	    f_allData.print("" + a_detTime[i] + ((i==actualNumAutomata-1)?"]\n":", "));
	}
	

	f_allData.print(" prunedSize: [");
	for (int i=0; i<actualNumAutomata; i++) {
	    f_allData.print("" + a_prunedSize[i] + ((i==actualNumAutomata-1)?"]\n":", "));
	}
	

	f_allData.print(" Universality: [");
	for (int i=0; i<actualNumAutomata; i++) {
	    f_allData.print("" + (a_universality[i] ? "1":"0") + ((i==actualNumAutomata-1)?"]\n":", "));
	}
    
	// Times
	f_detTime.print(" "+form.format(Utils.getMedian(a_detTime, actualNumAutomata)));
	f_unicheckTime.print(" "+form.format(Utils.getMedian(a_unicheckTime, actualNumAutomata)));
	f_minTime.print(" "+form.format(Utils.getMedian(a_minTime, actualNumAutomata)));
	f_averageDetTime.print(" "+form.format(Utils.getMean(a_detTime, actualNumAutomata)));
	f_stdevDetTime.print(" " + form.format(Utils.getStandardDeviation(a_detTime, actualNumAutomata)));
    
	//Sizes
	f_prunedSize.print(" "+form.format(Utils.getMedian(a_prunedSize, actualNumAutomata)));
	f_detSize.print(" "+form.format(Utils.getMedian(a_detSize, actualNumAutomata)));
	f_minSize.print(" "+form.format(Utils.getMedian(a_minSize, actualNumAutomata)));
	f_averageMinSize.print(" " + form.format(Utils.getMean(a_minSize, actualNumAutomata)));
    
	//Memory
	long totalMem = Utils.getMedian(a_totalMem, actualNumAutomata);
	f_totalMem.print(" "+(totalMem));
	f_initiallyfreeMem.print(" "+(totalMem - Utils.getMedian(a_initiallyfreeMem, actualNumAutomata)));
	f_afterdetMem.print(" "+(totalMem - Utils.getMedian(a_afterdetMem, actualNumAutomata)));
	f_afterunicheckMem.print(" "+(totalMem - Utils.getMedian(a_afterunicheckMem, actualNumAutomata)));
	f_afterminMem.print(" "+(totalMem - Utils.getMedian(a_afterminMem, actualNumAutomata)));
	f_finallyfreeMem.print(" "+(totalMem - Utils.getMedian(a_finallyfreeMem, actualNumAutomata)));
    }
}


