package dk.extra;
import dk.extra.Utils;
import java.io.*;
import java.util.*;
import java.text.DecimalFormat;
import java.util.regex.*;

/** Parses the files output by the Automata Complementor */
public class ParsingDriver {
  
  /* Global variables */
  
    private static IDataParser _dataParser;
    private static boolean forceMode = false;
  
    /* The constructor */
    public ParsingDriver(IDataParser d) {
	_dataParser = d;
    }
    
    /** The fun starts here. Parse the inputs and call the next method */
    public void theMain(String[] args) {
	DecimalFormat rFormatter = new DecimalFormat("0.00");
	DecimalFormat fFormatter = new DecimalFormat("0.00"); //default value, may be changed by caller, see main()
    
    
	String sourceDir = "";
	String outputDir = "";
	int rank=0;
	boolean bSource=true;
	boolean bOutput=true;//to make sure user supplies parameters
	boolean fMissing = true;
        
	String idTag= "";
	if (args.length < 4) {
	    System.err.println ("-sSource -dDestination -iIdTag -rRank -f[integer|linear]");
	    System.exit(2);
	}
    
	for (int i=0; i<args.length; i++) {
	    char marker = args[i].charAt(1);
	    switch (marker) {
	    case 's': 
		sourceDir = args[i].substring(2); 
		bSource=false; 
		break;
	    case 'd': 
		outputDir = args[i].substring(2); 
		bOutput=false; 
		break;
	    case 'i': 
		idTag = args[i].substring(2); 
		break;
	    case 'f':
		fMissing = false;
		String finals = args[i].substring(2).toLowerCase();
		if (finals.indexOf("int")>-1)
		    fFormatter = new DecimalFormat("0");
		else if (finals.indexOf("lin")>-1)
		    fFormatter = new DecimalFormat("0.00");
		else 
		    System.err.println("Unknown final states descriptor: "+args[i]+". Using the default double 0.00 formatter!");
          
		_dataParser.setFinalStateFormatter(fFormatter);
		break;
	    case 'r': 
		rank = Integer.parseInt(args[i].substring(2)); 
		break;
	    case 'g':
		forceMode = true;
		break;
	    default: 
		System.out.println("Unsupported option "+args[i]);
	    }//switch
	}//for length of input
    
	if (bSource || bOutput || fMissing) {
	    System.out.println("Must supply input and output directory!");
	    System.exit(20);
	}
    
	File source = new File(sourceDir);
	File destination = new File(outputDir);
    
	System.out.println("Data parser inputs: \n source="+source.toString()+
			   ",\noutput="+outputDir+", \nidTag="+idTag+
			   "\nrank: "+rank+"\nfFormatter: "+fFormatter.toLocalizedPattern()+".");
    
	// Check if the two directories exist
	if (! source.exists()) {
	    System.err.println("The source directory doesn't exist! I am exiting now!");
	    System.exit (9);
	}
    
    
    
	if (! destination.exists()) {
	    System.out.println("Destination directory doesn't exist. Process 0 is attempting to create it now!");
	    if ( destination.mkdirs())
		System.out.println("Destination directory successfully created!");
	    else {
		System.err.println("Couldn't create output directory. Exiting");
		System.exit(10);
	    }
	}
    
    
	_dataParser.printMyName();
	preprocess(source, destination, idTag, rank);
    
    
    
    }//main
  
    /*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/
  
  
    /** Do the actual work of parsing the files and generating the agregate data */
    public static void preprocess(File sourceDir, File output, String idtag, int rank) {
    
	//File[] dataDirectories = sourceDir.listFiles(Utils.nameContains(idtag));
	ArrayList rdensity = new ArrayList();
	ArrayList fdensity = new ArrayList();
	ArrayList sizeArray = new ArrayList();
    
	int size = 0;
	int numAutomata = 0;
    
	File[] dataFiles = sourceDir.listFiles(Utils.validNames);
	System.out.println("There are "+dataFiles.length+" files in the source dir");
    
	for (int i=0; i<dataFiles.length; i++) {
      
	    //parse the file name to get the size and the density
	    String fileName = dataFiles[i].getName().toString();
	    Pattern p_name = Pattern.compile("\\w*-*s-*(\\d+)" + //Group 1: size
					     "-*r-*(\\d+\\.\\d+)" + // Group2: rdensity
					     "-*f-*(\\d+\\.\\d+)" + // Group3: fdensity
					     "[\\w-]*" + 
					     "--(\\d+)-of-(\\d+)" + // Group 4: seqno
					     ".*"); // Group 5: total number
	    Matcher m = p_name.matcher(fileName);
	    Utils.affirm(m.matches(), "Couldn't pattern match the name " + fileName + "in ParsingDriver!");
	    rdensity.add(new Double(m.group(2)));
	    fdensity.add(new Double(m.group(3)));
	    int currentSize = Integer.parseInt(m.group(1));
	    sizeArray.add(new Integer(m.group(1)));
	    size = currentSize;

	    int totalCount = Integer.parseInt(m.group(5));
      
	    if (numAutomata == 0)
		numAutomata = totalCount;
      
	    else if (numAutomata != totalCount) {
		System.err.println("The file tags are not consistent about the number of automata: "+
				   "\nas specified by the file tags: " + numAutomata + 
				   "\nas specified in another file tag: " + totalCount);
		
	    }//elseif
      
      
	}//for all automata
    
	System.out.println("All filenames parsed. The file tags appear to be consistent.");
    
	removeDuplicate(rdensity);
	removeDuplicate(fdensity);
	removeDuplicate(sizeArray);
	Collections.sort(rdensity);
	Collections.sort(fdensity);
	Collections.sort(sizeArray);
    
	
    
	try {
	    PrintWriter sizeDescriptor = new PrintWriter (new FileWriter (new File(output, "sizeDescriptor")));
	    PrintWriter rDensityDescriptor = new PrintWriter (new FileWriter (new File(output, "rDensityDescriptor")));
	    PrintWriter fDensityDescriptor = new PrintWriter (new FileWriter (new File(output, "fDensityDescriptor")));
      
	    sizeDescriptor.println(sizeArray.toString());//ready for matlab
	    rDensityDescriptor.println(rdensity.toString());
	    fDensityDescriptor.println(fdensity.toString());
      
	    sizeDescriptor.close();
	    rDensityDescriptor.close();
	    fDensityDescriptor.close();
	}
	catch (IOException e) {
	    System.err.println("Error creating the descriptors.\n" + e);
	}
    
	if (rank == 0)
	    _dataParser.parseLandscapeData(rdensity, fdensity, sizeArray, sourceDir, output, numAutomata);
	else
	    _dataParser.parseScalingData(rdensity, fdensity, sizeArray, sourceDir, output, numAutomata);
    }//preprocess
  
  

    /*
    public static void parseLandscapeData(ArrayList rDensity, ArrayList fDensity, ArrayList sizeArray,
					  File sourceDir, File output, int expectedCount){
	System.err.println("Parse Landscape Data should be redefined!");
    };
  
    public static void parseScalingData(ArrayList rDensity, ArrayList fDensity, ArrayList sizeArray,
					File sourceDir, File output, int expectedCount){
	System.err.println("Parse Scaling Data should be redefined!");
    };
    */
  
  
    /*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/
  
    public static void removeDuplicate(ArrayList arlList)   {
	/** List order not maintained **/
	HashSet h = new HashSet(arlList);
	arlList.clear();
	arlList.addAll(h);
    }
  
}
