package dk.extra;
import java.util.*;
import java.io.*;
import dk.extra.*;
import java.util.regex.*;

class NuSMVFileParser implements IFileParser {
  
    private double _userTime = 0;
    private double _sysTime = 0;
    private boolean _universal = false;
    private int _nodes = 0;
    private double _heuristicTime = 0;
    private File _theFile;
  
    public NuSMVFileParser(File f) {
	_theFile = f;
    }
  
    public MeasuredTime getComplementTime() {
	System.err.println("getComplementTime should be defined in FileParser!");
	return null;
    }

    public MeasuredTime getEmptynessCheck() {
	System.err.println("getEmptynessCheck should be defined in FileParser!");
	return null;
    }

    public double getUserTime() {
	return _userTime;
    }
  
    public double getSystemTime(){
	return _sysTime;
    }
  
    public boolean isUniversal() {
	return _universal;
    }
  
    public int getNodes(){
	return _nodes;
    }
  
    public double getHeuristicTime(){
	return _heuristicTime;
    }
  
    public int parse() {
	try {
	    BufferedReader in = new BufferedReader ( new FileReader (_theFile));
	    String s;
      
	    boolean requiredInputs[] = new boolean[3];
	    for (int j=0; j<requiredInputs.length; j++) 
		requiredInputs[j] = false;
      
      
	    //check universality
	    while ( (s=in.readLine()) != null) {
		if (s.toLowerCase().indexOf("true") != -1) {
		    requiredInputs[0] = true; 
		    _universal = true;
		}
        
		if (s.toLowerCase().indexOf("false") != -1) {
		    requiredInputs[0] = true; 
		    _universal = false;
		}
        
		if (s.indexOf("User time") == 0) {
		    requiredInputs[1] = true;
		    int intBeginsAt = "User time".length();
		    while (s.charAt(intBeginsAt+1)==' ' || s.charAt(intBeginsAt+1)=='\t' )
			intBeginsAt++;
          
		    int intEndsAt = s.indexOf(" seconds");
		    _userTime = Double.parseDouble(s.substring(intBeginsAt, intEndsAt));
          
		    //System.out.println("Parsed: "+userTime);
		}//user time
        
		else if (s.indexOf("System time") == 0 ) {
		    requiredInputs[2] = true;
		    //System.out.println(s);
		    int intBeginsAt = "System time".length();
		    while (s.charAt(intBeginsAt+1)==' ' || s.charAt(intBeginsAt+1)=='\t' )
			intBeginsAt++;
          
		    int intEndsAt = s.indexOf(" seconds");
		    _sysTime = Double.parseDouble(s.substring(intBeginsAt, intEndsAt));
		} //system time
        
		else if (s.indexOf("BDD nodes allocated:") == 0) {
		    int intBeginsAt = "BDD nodes allocated:".length();
		    while (s.charAt(intBeginsAt+1)==' ' || s.charAt(intBeginsAt+1)=='\t' )
			intBeginsAt++;
          
		    int intEndsAt = s.indexOf("\n");
		    _nodes = Integer.parseInt(s.substring(intBeginsAt+1));
          
		} //alloc nodes
	    } //while
      
	    in.close();
	} //try
	catch (IOException e) {
	    System.err.println(e);
	    System.exit(1234);
	}
    
	return 0;
    }
    
}



class CadenceSMVFileParser implements IFileParser {
    private double _userTime = 0;
    private double _sysTime = 0;
    private boolean _universal = false;
    private int _nodes = 0;
    private double _heuristicTime = 0;
    private File _theFile;
  

    public MeasuredTime getComplementTime() {
	System.err.println("getComplementTime should be defined in FileParser!");
	return null;
    }

    public MeasuredTime getEmptynessCheck() {
	System.err.println("getEmptynessCheck should be defined in FileParser!");
	return null;
    }

    public CadenceSMVFileParser(File f) {
	_theFile = f;
    }
    public double getUserTime() {
	return _userTime;
    }
  
    public double getSystemTime(){
	return _sysTime;
    }
  
    public boolean isUniversal() {
	return _universal;
    }
  
    public int getNodes(){
	return _nodes;
    }
  
    public double getHeuristicTime(){
	return _heuristicTime;
    }
  
  
    public int parse() {
	
	try {
	    BufferedReader in = new BufferedReader ( new FileReader (_theFile));
	    String s;
      
	    boolean requiredInputs[] = new boolean[3];
	    for (int j=0; j<requiredInputs.length; j++) 
		requiredInputs[j] = false;
      
	    /* First parse the formula truth value */
	    do {
		s=in.readLine();
		if (s==null) {
		    System.err.println("Cannot determine the universality from file "+_theFile);
		    System.exit(1234);
		}
	    } while (s.indexOf("true") == -1 && s.indexOf("false") == -1);
      
	    if (s.indexOf("true") != -1) {
		_universal = true;
	    }
	    else if (s.indexOf("false") != -1)
		_universal = false;
	    else {
		System.err.println("Couldn't parse the truth value of the formula "+s);
		System.exit(1234);
	    }
      
	    /* Go all the way down to this line */
	    do {
		s=in.readLine();
	    } while (s.indexOf("Resources used") == -1);
      
      
	    while ( (s=in.readLine()) != null) {
        
		if (s.toLowerCase().indexOf("user time") == 0) {
		    requiredInputs[1] = true;
		    int intBeginsAt = "user time".length();
		    while (s.charAt(intBeginsAt+1)==' ' || s.charAt(intBeginsAt+1)=='\t'  || s.charAt(intBeginsAt+1)=='.')
			intBeginsAt++;
          
		    int intEndsAt = s.lastIndexOf(" s");
		    _userTime = Double.parseDouble(s.substring(intBeginsAt+1, intEndsAt));
		}//user time
        
		else if (s.toLowerCase().indexOf("system time") == 0 ) {
		    requiredInputs[2] = true;
		    //System.out.println(s);
		    int intBeginsAt = "System time".length();
		    while (s.charAt(intBeginsAt+1)==' ' || s.charAt(intBeginsAt+1)=='\t' || s.charAt(intBeginsAt+1)=='.')
			intBeginsAt++;
		    int intEndsAt = s.lastIndexOf(" s");
		    _sysTime = Double.parseDouble(s.substring(intBeginsAt+1, intEndsAt));
		} //system time
        
		else if (s.indexOf("BDD nodes allocated") == 0) {
		    requiredInputs[0] = true;
          
		    int intBeginsAt = "BDD nodes allocated".length();
		    while (s.charAt(intBeginsAt+1)==' ' || s.charAt(intBeginsAt+1)=='\t'  || s.charAt(intBeginsAt+1)=='.')
			intBeginsAt++;
          
		    int intEndsAt = s.indexOf("\n");
		    _nodes = Integer.parseInt(s.substring(intBeginsAt+1));
          
		} //alloc nodes
	    } //while
	    in.close();
      
	    for (int j=0; j<requiredInputs.length; j++) {
		if (! requiredInputs[j]) {
		    System.err.println("Missing required input " + j + "in file "+_theFile);
		    System.exit(1234);
		}
	    }
    
	}// try
	catch (IOException e) {
	    System.err.println(e);
	    System.exit(1234);
	}
  
	return 0;
    }
}








class CadenceGatoradeFileParser implements IFileParser {
    private double _userTime = 0;
    private double _sysTime = 0;
    private boolean _universal = false;
    private int _nodes = 0;
    private double _heuristicTime = 0;
    private File _theFile;
    
    boolean _timedOut = false;

    public MeasuredTime getComplementTime() {
	System.err.println("getComplementTime should be defined in FileParser!");
	return null;
    }

    public MeasuredTime getEmptynessCheck() {
	System.err.println("getEmptynessCheck should be defined in FileParser!");
	return null;
    }

    public CadenceGatoradeFileParser(File f) {
	_theFile = f;
    }
    public double getUserTime() {
	return _userTime;
    }
  
    public double getSystemTime(){
	return _sysTime;
    }
  
    public boolean isUniversal() {
	if (!_timedOut)
	    return _universal;
	else
	    throw new AssertionError("Asking for universaltity of a timed out automaton!");
    }
  
    public int getNodes(){
	return _nodes;
    }
  
    public double getHeuristicTime(){
	return _heuristicTime;
    }
  
  
    public int parse() {
	
	try {
	    BufferedReader in = new BufferedReader ( new FileReader (_theFile));
	    String s;
      
	    boolean requiredInputs[] = new boolean[3];
	    for (int j=0; j<requiredInputs.length; j++) 
		requiredInputs[j] = false;
      

	    while ( (s=in.readLine()) != null) {
		if (s==null)
		    throw new AssertionError("This is impossible!");
		
		/*************************/
		/* Checking universality */
		/*************************/
		Pattern sanity = Pattern.compile("\\(AG \\(first_state\\|\\(subset\\[\\d+\\] ->\\(rank\\[\\d+\\] in .+(true|false)");
		Matcher m = sanity.matcher(s);
		if (m.matches()) {
		    /*This is a sanity check line. The result would better be true, or otherwise we quit.*/
		    Utils.affirm(m.group(1).equalsIgnoreCase("true"), "Sanity check in CadenceGatorade Parser");
		}

		Pattern property = Pattern.compile("0\\.+(true|false)");
		m = property.matcher(s);
		if (m.matches()) {
		    //This is the property line. Check the universality of the automaton
		    _universal = m.group(1).equalsIgnoreCase("true"); // No
								       // accepting
								       // cycle
								       // through
								       // the
								       // complemented
								       // automaton
		    requiredInputs[0] = true;
		}
		
		
		// Parsing the reported time
		Pattern userTime = Pattern.compile("Measured User time: (\\d+\\.\\d+)");
		m = userTime.matcher(s);
		if (m.matches()) {
		    _userTime = Float.parseFloat(m.group(1));
		    requiredInputs[1] = true;
		}


		Pattern sysTime = Pattern.compile("Measured System time: (\\d+\\.\\d+)\\s*");
		m = sysTime.matcher(s);
		if (m.matches()) {
		    _sysTime = Float.parseFloat(m.group(1));
		    requiredInputs[2] = true;
		}

		//System.out.println(s + "<<");

	    } //while

	    in.close();
      
	    boolean missingInput = false;
	    int numMissingInputs = 0;

	    for (int j=0; j<requiredInputs.length; j++) {
		if (! requiredInputs[j]) {
		    System.err.println("Missing required input " + j + " in file "+_theFile);
		    missingInput = true;
		    numMissingInputs ++;
		}
	    }


	    
	    if (missingInput) {
		// If all three are missing, then it is probably a timeout. 
		if (numMissingInputs == requiredInputs.length) {
		    _timedOut = true;

		    return ADataParser.TIMEOUT_FLAG;
		}
		
		else
		    return -1;
	    }
    
	}// try
	catch (IOException e) {
	    System.err.println(e);
	    return -1;
	}
  
	return 0;
    }
}
