package dk.extra;
import java.text.DecimalFormat;
import java.util.regex.*;

/** Static methods for use in other programs
 * Deian Tabakov 2004
 */
public class Utils {
  
    public static int toInt(double density, double start, double step){
	/**Converts a density, which is a double, into a consistent 
	 * integer, so that all densities map uniquely to consequtive
	 * numbers
	 */
	return (int) Math.round((density-start)/step);
    }
      
    /*#########################################################################*/  
      
    public static String formattedDouble(int toInt, double start, double step, String pattern) {
	/** Undoes what the previous command does, with the twist that
	 * it returns a String rather than a double, with a predetermined format
	 */
	java.text.DecimalFormat myFormatter = new java.text.DecimalFormat(pattern);
	return myFormatter.format(start + toInt * step);
    }
    
    /*#########################################################################*/
    
    public static double toDouble(int toInt, double start, double step) {
	/** Same as the previous command, but returns a double
	 */
	return (start + toInt * step);
    }
    
    /*#########################################################################*/
    
    
    /**
     * Returns a MeasuredTime object that holds the medians for each
     * measurable inside MeasuredTime.
     */
    public static MeasuredTime getMedian(MeasuredTime[] array, int size) {

	// Note that the index is one lower than the cardinal!
	int leftIndex = -1 + (int) Math.ceil(size/2.0);
	int rightIndex = -1 + (int) Math.ceil((size + 1)/2.0);
 
	double[] user = new double[size];
	double[] system = new double[size];
	double[] total = new double[size];
	double[] tool = new double[size];
 
	for (int i=0; i<size; i++) {
	    if (array[i].getTimeout()) {
		user[i] = MeasuredTime.VERY_LONG_TIME;
		system[i] = MeasuredTime.VERY_LONG_TIME;
		total[i] = MeasuredTime.VERY_LONG_TIME;
		tool[i] = MeasuredTime.VERY_LONG_TIME;
	    }
	    else {
		user[i] = array[i].getUserTime();
		system[i] = array[i].getSystemTime();
		total[i] = array[i].getTotalTime();
		tool[i] = array[i].getToolTime();
	    }
	}
 
	java.util.Arrays.sort(user);
	java.util.Arrays.sort(system);
	java.util.Arrays.sort(total);
	java.util.Arrays.sort(tool);

	MeasuredTime toReturn = new MeasuredTime();
 
	// Need to handle cases when the input array is empty (size = 0)
	if (size == 0) {
	    toReturn.bzero();
	    System.err.println("Utils: the medians are zero because the input array has size 0");
	}
	else {
	    toReturn.setUserTime( (  user[leftIndex] +   user[rightIndex])/ 2.0);
	    toReturn.setSystemTime( (system[leftIndex] + system[rightIndex])/ 2.0);
	    toReturn.setTotalTime( ( total[leftIndex] +  total[rightIndex])/ 2.0);
	    toReturn.setToolTime( (  tool[leftIndex] +   tool[rightIndex])/ 2.0);
	}
 
	return toReturn;
    }











    /**
     * Returns a MeasuredTime object that holds the means for each
     * measurable inside MeasuredTime.
     */
    public static MeasuredTime getMean(MeasuredTime[] array, int size) {


	double[] user = new double[size];
	double[] system = new double[size];
	double[] total = new double[size];
	double[] tool = new double[size];
 
	for (int i=0; i<size; i++) {
	    if (array[i].getTimeout()) {
		user[i] = MeasuredTime.VERY_LONG_TIME;
		system[i] = MeasuredTime.VERY_LONG_TIME;
		total[i] = MeasuredTime.VERY_LONG_TIME;
		tool[i] = MeasuredTime.VERY_LONG_TIME;
	    }
	    else {
		user[i] = array[i].getUserTime();
		system[i] = array[i].getSystemTime();
		total[i] = array[i].getTotalTime();
		tool[i] = array[i].getToolTime();
	    }
	}
	

	MeasuredTime toReturn = new MeasuredTime();
 
	// Need to handle cases when the input array is empty (size = 0)
	if (size == 0) {
	    toReturn.bzero();
	    System.err.println("Utils: the means are zero because the input array has size 0");
	}
	else {
	    toReturn.setUserTime  ( getMean(user,   size));
	    toReturn.setSystemTime( getMean(system, size));
	    toReturn.setTotalTime ( getMean(total,  size));
	    toReturn.setToolTime  ( getMean(tool,   size));
	}
 
	return toReturn;
    }








    /**
     * Returns a MeasuredTime object that holds the standard
     * deviations for each measurable inside MeasuredTime.
     */
    public static MeasuredTime getStandardDeviation(MeasuredTime[] array, int size) {

	double[] user = new double[size];
	double[] system = new double[size];
	double[] total = new double[size];
	double[] tool = new double[size];
 
	for (int i=0; i<size; i++) {
	    if (array[i].getTimeout()) {
		user[i] = MeasuredTime.VERY_LONG_TIME;
		system[i] = MeasuredTime.VERY_LONG_TIME;
		total[i] = MeasuredTime.VERY_LONG_TIME;
		tool[i] = MeasuredTime.VERY_LONG_TIME;
	    }
	    else {
		user[i] = array[i].getUserTime();
		system[i] = array[i].getSystemTime();
		total[i] = array[i].getTotalTime();
		tool[i] = array[i].getToolTime();
	    }
	}
	

	MeasuredTime toReturn = new MeasuredTime();
 
	// Need to handle cases when the input array is empty (size = 0)
	if (size == 0) {
	    toReturn.bzero();
	    System.err.println("Utils: the means are zero because the input array has size 0");
	}
	else {
	    toReturn.setUserTime  ( getStandardDeviation(user,   size));
	    toReturn.setSystemTime( getStandardDeviation(system, size));
	    toReturn.setTotalTime ( getStandardDeviation(total,  size));
	    toReturn.setToolTime  ( getStandardDeviation(tool,   size));
	}
 
	return toReturn;
    }







    /**
     * Returns the maximum element in the array
     */
    public static int getMax(int[] array, int size) {
	int running = Integer.MIN_VALUE;

	for (int i=0; i<size; i++) {
	    if (array[i] > running)
		running = array[i];
	}

	return running;
	
    }
	
	
	
	




    public static double getMedian(int[] array, int size) {
	/** returns the median value of the int array */
    
	int leftIndex = -1 + (int) Math.ceil(size/2.0);
	int rightIndex = -1 + (int) Math.ceil((size + 1)/2.0);
	java.util.Arrays.sort(array);
	return (array[leftIndex] + array[rightIndex]) / 2.0;
    }
  
    /*#########################################################################*/
  
    public static double getMedian(double[] array, int size) {
	/** returns the median value of the double array */
    
	int leftIndex = -1+(int) Math.ceil(size/2.0);
	int rightIndex = -1+(int) Math.ceil((size+1)/2.0);
	java.util.Arrays.sort(array);
	return (array[leftIndex] + array[rightIndex]) / 2.0;
    }
    
    /*#########################################################################*/
  
    public static long getMedian(long[] array, int size) {
	/** returns the median value of the long array */
    
	int leftIndex = -1+(int) Math.ceil(size/2.0);
	int rightIndex = -1+(int) Math.ceil((size + 1)/2.0);
	java.util.Arrays.sort(array);
	return (array[leftIndex] + array[rightIndex])/2; // possible round off error 
    }  
    /*#########################################################################*/ 
    
    public static double getMean(int[] array, int size) {
	/** returns the median value of the int array */
	int total = 0;
	for (int i=0; i< size; i++)
	    total += array[i];
	return total/(size * 1.0);
    }
  




    /** 
     * Returns the mean value of the double array 
     */
    public static double getMean(double[] array, int size) {
	
	double total = 0;
	for (int i=0; i< size; i++)
	    total += array[i];
	return total/(size * 1.0);
    }
  






    /**
     * Returns the standard deviation of the array
     */
    public static double getStandardDeviation(int[] array, int size) {
	if (size==0)
	    throw new AssertionError("The size should be positive!");
 
	double mean = getMean(array, size);
	double runningSum = 0.0;

	for (int i=0; i<size; i++) {
	    double diff = mean - (double) array[i];
	    runningSum += diff * diff;
	}
 
	return Math.sqrt(runningSum/((double)(size-1)));
    }






    /**
     * Returns the standard deviation of the array. This is the double
     * variety.
     */
    public static double getStandardDeviation(double[] array, int size) {
	if (size==0)
	    throw new AssertionError("The size should be positive!");
 
	double mean = getMean(array, size);
	double runningSum = 0.0;

	for (int i=0; i<size; i++) {
	    double diff = mean - array[i];
	    runningSum += diff * diff;
	}
 
	return Math.sqrt(runningSum/((double)(size-1)));
    }







    /*#########################################################################*/

    public static java.io.FilenameFilter validNames= new java.io.FilenameFilter() {
	    public boolean accept(java.io.File dir, String name) {
		if ( name.indexOf("--") != -1 && name.indexOf("-of-") != -1 )
		    return true;
		else {
		    System.out.println("Found an illegal name in this directory: "+dir+name);
		    return false;
		}
	    }
	};
  
    /*#########################################################################*/
    
    public static java.io.FilenameFilter nameContains(final double r, final DecimalFormat rFormatter, 
						      final double f, final DecimalFormat fFormatter) 
    {
	return new java.io.FilenameFilter() {
		public boolean accept(java.io.File dir, String name) {
		    Pattern p = Pattern.compile(".*-*r-*(\\d+\\.\\d+)" + // Group1: rdensity
						"-*f-*(\\d+\\.\\d+).*"); // Group2: fdensity
      
		    Matcher m = p.matcher(name);
		    if (m.matches() &&
			m.group(1).equals(""+rFormatter.format(r)) &&
			m.group(2).equals(""+fFormatter.format(f)))
			return true;
		    else {
			return false;
		    }
		}
	    };
    }
  
    /*#########################################################################*/
  
    public static java.io.FilenameFilter nameContains(final int size, 
						      final double r, 
						      final DecimalFormat rFormatter, 
						      final double f, 
						      final DecimalFormat fFormatter) {
	return new java.io.FilenameFilter() {
		public boolean accept(java.io.File dir, String name) {
		    Pattern p = Pattern.compile(".*-*s-*(\\d+)-*r.+");
		    Matcher m = p.matcher(name);
		    if (m.matches() && 
			m.group(1).equals(""+size) &&
			nameContains(r, rFormatter, f, fFormatter).accept(dir, name))
			return true;
		    else
			return false;
		}
	    };
    }
    /*#########################################################################*/
    
    public static java.io.FilenameFilter nameContains(final String id) {
	return new java.io.FilenameFilter() {
		public boolean accept(java.io.File dir, String name) {
        
		    if (name.indexOf(id)>-1)
			return true;
		    else
			return false;
		}
	    };
    }
  
    /*#########################################################################*/
  
    public static java.io.FilenameFilter validNames(final int rank, final int numProcs) {
	if (rank>numProcs) {
	    System.err.println("Parameter rank="+rank + "cannot be bigger than number of processors ("+numProcs+")");
	    System.exit(15);
	}
	return new java.io.FilenameFilter() {
		public boolean accept(java.io.File dir, String name) {
		    //get the sequential number from the file name
		    int seqNumStarts = name.indexOf("--")+2;
		    int seqNumEnds = name.indexOf("-of-");
		    int seqNum = Integer.parseInt(name.substring(seqNumStarts, seqNumEnds));
		    if (seqNum % numProcs == rank)
			return true;
		    else
			return false;
		}
	    };
    }
    
    /*#########################################################################*/
    public static void affirm(boolean assertion, String description) {
	if (! assertion) {
	    System.err.println("Assertion violation!\n"+description);
	    System.exit(1234);
	}
    }
  
}
