/**CHeaderFile*****************************************************************

  FileName    [pkg_traceInt.h]

  PackageName [trace]

  Synopsis    [The internal header file for the <tt>trace</tt> package]

  Description []

  SeeAlso     []

  Author      [Ashutosh Trivedi]

  Copyright   [
  This file is part of the ``trace'' package of NuSMV version 2.
  Copyright (C) 2003 by FBK-irst.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on NuSMV see <http://nusmv.fbk.eu>
  or email to <nusmv-users@fbk.eu>.
  Please report bugs to <nusmv-users@fbk.eu>.

  To contact the NuSMV development board, email to <nusmv@fbk.eu>. ]

******************************************************************************/
#ifndef __PKG_TRACE_INT__H
#define __PKG_TRACE_INT__H

#include "utils/utils.h" /* For EXTERN */
#include "utils/utils_io.h"
#include "node/node.h"

#include "TraceManager.h"
#include "TraceXml.h"


#include "Trace_private.h"
#include "exec/traceExec.h"
#include "exec/TraceExecInfo.h"

#include "compile/compile.h"
#include "fsm/FsmBuilder.h"
#include "opt/opt.h"
#include "utils/NodeList.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
EXTERN FILE* nusmv_stderr;
EXTERN FILE* nusmv_stdout;
EXTERN TraceManager_ptr global_trace_manager;
EXTERN FsmBuilder_ptr global_fsm_builder;
EXTERN int yylineno;
EXTERN cmp_struct_ptr cmps;

/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototype                                                        */
/*---------------------------------------------------------------------------*/

/* BDD-based re-execution */
EXTERN int trace_bdd_execute_trace ARGS((Trace_ptr trace,
                                         TraceExecInfo_ptr exec_info));

EXTERN int trace_bdd_execute_partial_trace ARGS((Trace_ptr trace,
                                                 TraceExecInfo_ptr exec_info,
                                                 int* trace_index));

/* this is not currently implemented */
EXTERN int
trace_bdd_execute_partial_trace_restart ARGS((Trace_ptr trace,
                                              TraceExecInfo_ptr exec_info,
                                              int* trace_index));

/* SAT based re-execution */
EXTERN int trace_sat_execute_trace ARGS((Trace_ptr trace,
                                         TraceExecInfo_ptr exec_info));

EXTERN int trace_sat_execute_partial_trace ARGS((Trace_ptr trace,
                                                 TraceExecInfo_ptr exec_info,
                                                 int* trace_index));

EXTERN int
trace_sat_execute_partial_trace_restart ARGS((Trace_ptr trace,
                                              TraceExecInfo_ptr exec_info,
                                              int* trace_index));

/* used for restart */
EXTERN boolean
trace_exec_is_complete_state_assignment ARGS((const Trace_ptr trace,
                                              const TraceIter step));

/**AutomaticEnd***************************************************************/

#endif /* __TRACE_INT__H */
