#include "errors.h"

/************************** 
 * Error-handling functions
 **************************/

void unix_error(char *msg, ...) /* unix-style error */
{
  va_list arg_list;

  va_start(arg_list, msg); //initialize the bstatearg list

  vfprintf(stderr, msg, arg_list);

  va_end(arg_list);
  if (strcmp(strerror(errno), "Success") != 0)
    fprintf(stderr, "%s\n", strerror(errno));

  exit(0);
}




void posix_error(int code, char *msg) /* posix-style error */
{
  fprintf(stderr, "%s: %s\n", msg, strerror(code));
  exit(0);
}
