/***************************************************************************************************

 The containment analyzer is useful for checking the containment of two Buechi
 automata. Based on a SCT analyzer by: 
 Copyright (C) 2004  Chin Soon Lee
 Further copyright (C) 2009 Seth Fogarty

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

 The authors can be contacted by e-mail at cslee_sg@hotmail.com and sfogarty@gmail.com.

***************************************************************************************************/

#define true			1
#define false			0
#define Malloc malloc
#define Free free
#define MAXINT			32767 /* 2147483647 */
#define wassert(x) (assert(x)) //a weak assertion, something that should always be true
//but if not true, won't immediately crash the program
//#define wassert(ignore)((void) 0)
//#define passert(x) (assert(x)) //a pathetic insertion, that could take a lot of time
#define passert(ignore)((void) 0)


#define whitespace(c)		(c==' ' || c=='\t' || c=='\n' || c=='\r')
#define digit(c)		(c>='0' && c<='9')
#define max(x,y)		(x<y? y:x)
#define bool_to_string(b)	(b? "#T": "#F")

typedef int bool;

typedef char *string;

void error(char *s);		/* report an error message */
int  roundInt(float x);	

void set_input_file(FILE *f);	/* set the input file for "readCP" */


/* To activate CMemLeak:

#define _DEBUG true  
#include "leak.h" 
#include "memory.h"
*/
#include <assert.h>
#include "errors.h"
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
