module Asyntax where
import List

data Program = Prog FDs
               deriving (Show,Eq)

type FDs = [FD]

type Varname = String

type Funname = String

data FD = FD Funname [Varname] Exp
	   deriving (Show,Eq)

data Exp = Var String
         | App Funname [Exp]
         | Fapp Int Funname [Exp] 
         | Pri Funname [Exp] 
         | Con Funname [Exp]
         | Des Funname [Exp]
         | If Exp Exp Exp
         | Let [Vardef] Exp
	    deriving (Show,Eq)

data Vardef = Def Varname Exp
	    deriving (Show,Eq)


-- Return the list of declared functions
funNames (Prog pgm) = map funNamesFD pgm
                      where funNamesFD (FD f xs e) = f

-- Return definition of function 
lookupFundef f (Prog fds) = 
  case [fd | fd@(FD f1 _ _)<-fds, f1==f] of
    (fd@(FD f1 _ _):fds) -> fd
    otherwise        -> error ("lookupFundef: function " ++ f 
                               ++ " is undefined")

-- Return variables for function f
funVars f (Prog pgm) = 
  case [xs | (FD g xs e)<-pgm, f==g ] of
    [xs] -> xs
    otherwise -> error ("funVars: can't find variables for function "++f++".")




-- Traversing a parse tree

mapPgm f (Prog fds) = (map f fds)

mapFD f (FD fname xs e) = f (fname, xs, e)

mapLetexp f l = map (appDefexp f) l

appDefexp f (Def _ e) = f e


lookupFun fname (Prog pgm) = 
  case [(xs, exp) | (FD fname0 xs exp)<-pgm, fname==fname0] of
    []              -> error ("Nonexisting function called: " ++ fname ++ "\n")
    ((xs, exp):fns) -> (xs, exp)

--Seth Fogarty: return a list of int parameters from a function def.
rankOfFunc pgm fname = length(fst(lookupFun fname pgm))

paramsOfFunc pgm fname = map (\x -> fname++"_"++(show x)) [0..(rankOfFunc pgm fname)-1]

rankOfParam pgm fname x = let xs = fst(lookupFun fname pgm) in 
    case elemIndex x xs of
    Just a -> a
    _ -> error ("Nonexisting parameter looked up")

rankOfPgm (Prog pgm) = 
   maximum [length(xs) | (FD fname0 xs exp) <- pgm]

showParam fname i = (show fname) ++ "_" ++ (show i)



