module Automata where

import Data.List
import Graphs
--only for combine

type State = Int
type Start state = [state]
type Rho state = [(state, Int, state)]
type Final state = [state]
data PAutomaton a =  Automaton Int [a] (Start a) (Rho a) (Final a) deriving (Eq, Show)
data SMVSpec = AG | Invar | Invarspec deriving (Eq, Show)
data Format = Set | Goal | Raskin | Deian | SMV SMVSpec deriving (Eq, Show)

type Automaton = PAutomaton State 

univ :: Automaton -> Automaton
univ (Automaton sigma _ _ _ _) = Automaton sigma [0] [0] [(0, c, 0) | c <- [0..(sigma-1)]] [0]

stringOfAutomaton :: Format -> Automaton -> String
stringOfAutomaton Deian (Automaton sigma states start rho final) =
      combine "\n" [size, "#init", startStr, "#rho", rhoStr,"#final", finalStr]
      where
        size = show (length states)
        startStr = [(contains x start):: Char | x <- states]
        rhoStr = combine "\n" [rhoMatrix char | char <- [0..(sigma-1)]]
        rhoMatrix char = combine "\n" [rhoLine char s1 | s1 <- states]
        rhoLine char s1 = [contains (s1, char, s2) rho | s2 <- states]
        finalStr = [contains x final | x <- states]
        contains e lst = if elem e lst then '1' else '0'

stringOfAutomaton Raskin (Automaton sigma states start rho final) =
      combine "\n" [size, "#init", startStr, "#rho", rhoStr,"#final", finalStr]
      where
        size = show (length states)
        tonum = rank states 
        startStr = combine " " [show (tonum state) | state <- start]
        rhoStr = combine "\n" ([combine " " [show (tonum s1), show (c), show (tonum s2)] | (s1, c, s2) <- rho]++["-"])
        finalStr = combine " " [show (tonum state) | state <-  final]


stringOfAutomaton Set aut = setStringOfAutomata (univ aut) (aut)

stringOfAutomaton (SMV spec) (Automaton sigma states start rho final) =
    combine "\n" ["MODULE main", stateStr, sigmaStr, "ASSIGN", initStr, rhoStr, finalStr]
    where
        stateRef state = "state["++(show (rank states state))++"]"
        contains e lst = if elem e lst then "1" else "0"
        stateStr = "VAR\n  state: array 0.."++(show ((length states)-1))++" of boolean;\n"
        sigmaStr = if sigma /= 2 
                   then error "Can only translate automata over two characters." 
                   else "IVAR\n  input: boolean;\n"
        initStr = combine "\n" ["  init("++(stateRef state)++") := "++(contains state start)++";" | state <- states]
        rhoStr = combine "\n" ["  next("++(stateRef state)++") := (\n"++ (nextForState state)++"  );" | state <- states]
        nextForState state = 
            case ["  ( "++(nextForTrans (c, s1))++" )" | (s1, c, s2) <- rho, s2==state] of
                [] -> "  0"
                prevs -> interleave "|\n" prevs
        nextForTrans (char, s1) = if char == 0 
                                  then (stateRef s1)++" & (input)"
                                  else (stateRef s1)++" & (! input)"
        finalHdr =  case spec of 
                        Invar -> "INVAR\n  "
                        AG -> "SPEC\n  AG "
                        Invarspec -> "INVARSPEC\n  "
        finalStr = finalHdr ++"("++ (interleave " | " [stateRef state | state <- final])++");"


stringOfAutomaton Goal (Automaton sigma states start rho final) =
      combine "\n" [header, alphabetStr, statesStr, rhoStr, initStr, finalStr, "</structure>"]
      where
        header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n"
               ++"<structure label-on=\"transition\" type=\"fa\">\n"
        alphabetStr = "\t<alphabet type=\"classical\">\n"
                    ++ combine "\n" [charStr char | char <- [0..(sigma-1)]]
                    ++ "\t</alphabet>\n"
        charStr char = "\t\t<symbol> "++show char++"</symbol>"
        statesStr =  "\t<stateSet>\n"
                  ++ combine "\n" [stateStr state | state <- states]
                  ++ "\t</stateSet>\n"
        stateStr state = "\t\t<state sid=\""++show state++"\"></state>"
        rhoStr =  "\t<transitionSet>\n"
               ++ combine "\n" [transitionStr transition | transition <- (zip rho [0..])]
               ++ "\t</transitionSet>\n"
        transitionStr ((s1,c,s2), id) = "\t\t<transition tid=\""++show id++"\">\n"
                                      ++ "\t\t\t<from>"++show s1++"</from>\n"
                                      ++ "\t\t\t<to>"++show s2++"</to>\n"
                                      ++ "\t\t\t<read>"++show c++"</read>\n"
                                      ++ "\t\t</transition>\n"
        initStr=  "\t<initialStateSet>\n"
                  ++ combine "\n" [stateRefStr state | state <- start]
                  ++ "\t</initialStateSet>\n"
        finalStr=  "\t<acc type=\"buchi\">\n"
                  ++ combine "\n" [stateRefStr state | state <- final]
                  ++ "\t</acc>\n"
        stateRefStr state = "\t\t<stateID>"++show state++"</stateID>"
   
stringOfReduction :: Format -> (Automaton, Automaton) -> String
stringOfReduction format (flow, desc) =
       case format of
         Deian -> "#Adjacency Matrix Containment\n1\n"++sigmaStr++autStr
         Raskin -> "#Arc List Containment\n3\n"++sigmaStr++autStr
         Goal -> autStr
         Set -> autStr 
       where 
         sigmaStr = "#number of letters\n"++show sigma++"\n#automaton\n"
         (Automaton sigma _ _ _ _) = flow
         autStr = if format == Set
                  then setStringOfAutomata flow desc
                  else (let 
                           descStr = stringOfAutomaton format desc
                           flowStr = stringOfAutomaton format flow 
                           in if format == Goal 
                           then descStr ++ flowStr 
                           else combine "\n" ["#flow automaton", flowStr, "#desc automaton", descStr])

setStringOfAutomata (Automaton sigmaA statesA startA rhoA finalA) (Automaton sigmaB statesB startB rhoB finalB) = 
      combine "\n" [aStateStr, bStateStr, sGraphStr] 
      where
         aStates = [(state, elem state startA, elem state finalA) | state <- statesA]
         bStates = [(state, elem state startB) | state <- statesB]
         sGraphs = [(source, dest, arcs c) | (source, c, dest) <- rhoA]
         arcs c = [(a, elem b finalB, b) | (a, i, b) <- rhoB, i == c] 
         showBit bit = if bit then "1" else "0"
         strOfAState (state, start, final) = 
            "("++show state++" "++showBit start++" "++showBit final++")"
         strOfBState (state, start) = 
            "("++show state++" "++showBit start++")"
         strOfGraph (source, dest, arcs) = 
            "("++show source++" "++show dest++" "++strOfArcs arcs++")"
         strOfArcs (arcs) = 
            "{"++(combine " " (map strOfArc arcs))++"}"
         strOfArc (source, desc, dest) = 
            "("++show source++" "++showBit desc++" "++show dest++")"
         aStateStr = 
            "{\n"++(combine " " (map strOfAState aStates ))++"\n}"
         bStateStr = 
            "{\n"++(combine " " (map strOfBState bStates ))++"\n}"
         sGraphStr = 
            "{\n"++(combine "\n" (map strOfGraph sGraphs))++"}"

stringOfAutomata :: Format -> Either (Automaton, Automaton) Automaton -> String
stringOfAutomata format (Left red) = stringOfReduction format red
stringOfAutomata format (Right aut) =
       case format of
         Deian -> "#Adjacency Matrix Universality\n0\n"++sigmaStr++autStr
         Raskin -> "#Arc List Universality\n2\n"++sigmaStr++autStr
         _ -> autStr
       where 
         sigmaStr = "#number of letters\n"++show sigma++"#automaton\n"
         (Automaton sigma _ _ _ _) = aut 
         autStr    = stringOfAutomaton format aut


automatonOfString :: Int -> [String] -> Automaton
automatonOfString sigma strs = 
        Automaton sigma states start rho final
        where
          size:init:rest = strs
          (trans, last) = break (=="-") rest
          
          states = [0..((read size)-1)]
          start = map read (words init)
          rho = map (\(a:i:b:_) -> (read a, read i, read b)) (map words trans)
          final = case last of
              "-":[] -> []
              "-":ln:_ -> map read (words ln)
              


automataOfString :: String -> Either (Automaton, Automaton) Automaton
automataOfString str =
       case format of 
          "3"  -> 
           let (astr, bstr) = splitAt index lns 
               a = automatonOfString sigma astr
               b = automatonOfString sigma bstr
           in Left (a,b)
          "2" -> Right (automatonOfString sigma lns)
          _  -> error "Only arc list containment supported"
       where
         format:lsize:lns = nocomments (lines str)
         (sigma :: Int) = read lsize
         index = case elemIndex "-" lns of
                  Nothing -> error "Invalid file format"
                  Just i -> i+2


emptyaut= Automaton 2 ["a","b","c"] ["a"] [("a",0,"b"), ("b",1,"c"), ("b",0,"b")] ["c"]
intaut1 = Automaton 2 ["a","b","c"] ["a"] [("a",0,"b"), ("b",1,"c"), ("b",0,"b")] ["b","c"]
intaut2 = Automaton 2 ["a","b","c"] ["a"] [("a",0,"b"), ("b",1,"c"), ("b",0,"b"), ("c", 1, "a")] ["c"]

clean_red (a1, a2) = (clean_aut a1, clean_aut a2)

clean_aut (Automaton sigma states start rho final) =
       Automaton sigma states' start' rho' final'
       where
         states' = map num states
         start' = map num start
         final' = map num final
         rho' = map (\ (a,c,b) -> (num a,c,num b)) rho
         num = rank states 


--bitstring :: Int -> (Automaton, Automaton)
--bitstring n =
 --  (Automaton sigma f_states f_start f_rho f_final,
  --  Automaton sigma d_states d_start d_rho d_final)
   --where
    --  sigma = 2*n
--
 --     f_states = [0, 1]
  --    f_start = [1]
   --   f_final = [0, 1]
    --  f_rho = union [(1, c, 0) | c <- [n..(2*n)-1]]
     --               [(0, c, 1) | c <- [0..n-1)]]
      --d_states =  

fix f v = 
  let fixit f v o = if v==o then v else fixit f (f v) v
  in fixit f (f v) v

checkFWuniversality (Automaton sigma states start rho final) =
    all (\ set -> ((intersect set final) /= [])) reachable_subsets
    where
        next_subset set char = nub [s2 | (s1, c, s2) <- rho, elem s1 set, c == char]
        next_subsets sets = nub (sets++[next_subset set char | char <- [0..(sigma-1)], set <- sets]) 
        reachable_subsets = fix next_subsets ([start])

        
