module Buechi where

import Parser
import Scgraph
import Unique
import Scc
import CallgraphExtract
import Dependency
import Automata
import SVWGraphs
import GroundedGraphs
import SCRed
import MCGraphs
import Redox
import Pathologies
import qualified Graphs

data OptLevel = NoOpt | OptOne | OptTwo | OptThree deriving (Show, Eq)

ensureContainment a = case a of
      Left (a,b) -> (a,b)
      Right b    -> (univ b, b)

class Eq a => Buechi a where
     solve :: a -> Bool
     toString :: a -> String
     toScGraphs :: a -> Scgraphs
     toAutomata :: a -> Either (Automaton, Automaton) Automaton
     reduce :: a -> Bool -> (Automaton, Automaton)
     toSVWGraphs :: a -> SVWGraphs --keeps track of states

--addEqImpsToMCArcs :: MCArcs -> MCArcs
--addTrImpsToMCArcs :: MCArcs -> MCArcs
--scGraphsOfMCGraphs :: [MCGraph] -> Scgraphs
--mcGraphsOfLines :: [String] -> [MCGraph]
--data Scgraphs =  Named ([NamedScgraph],(Program, NCallgraph)) 
--              | Vec ([Scgraph], [(Int, Int)]) 
--               | Limited ([Scgraph], [(Int, Int)], [Int]) 
--
instance Buechi ([MCGraph], OptLevel) where
    solve = solve . toScGraphs 
    toString mcgs = show mcgs
    toScGraphs (mcgs, NoOpt) = (removeNames . scGraphsOfMCGraphs) mcgs
    toScGraphs (mcgs, OptOne) = (removeNames . scGraphsOfMCGraphs) (addEqImpsToMCGraphs mcgs)
    toScGraphs (mcgs, OptTwo) = (removeNames . scGraphsOfMCGraphs) (addTrImpsToMCGraphs mcgs)
    toScGraphs (mcgs, OptThree) = (removeNames . scGraphsOfMCGraphs) (addTrImpsToMCGraphs mcgs)
    toAutomata = toAutomata . toScGraphs 
    reduce = reduce . toScGraphs
    toSVWGraphs = toSVWGraphs . toScGraphs


instance Buechi Scgraphs where 
    solve (Vec (gs, _)) = check_idempot gs
    solve (Limited (gs, _, fa)) = check_idempot_in gs fa
    solve (Named (gs, _)) = check_n_idempot gs
    solve (NamedVec (gs, _)) = check_n_idempot gs
    solve (NamedLimited (gs, _, fa)) = check_n_idempot_in gs fa
    toString x = stringOfScgraphs False x
    toScGraphs a = a
    toAutomata (Vec (gs, vec)) = Left (graphReduction False (csOfGraphs gs) (-1) vec gs)
    toAutomata (Limited (gs, vec, fa)) = Left (graphReduction False (csOfGraphs gs) (-1) vec gs)
    toAutomata (Named (gs, pgm)) = Left (scReduction False pgm gs)
    toAutomata (NamedVec a) = toAutomata (Vec (removeNamesWithMap a))
    toAutomata (NamedLimited a) = toAutomata (Limited (removeNamesAll a))
    reduce (Vec (gs, vec)) b = (graphReduction b (csOfGraphs gs) (-1) vec gs)
    reduce (Limited (gs, vec, fa)) b = (graphReduction b (csOfGraphs gs) (-1) vec gs)
    reduce (Named (gs, pgm)) b = (scReduction b pgm gs)
    reduce (NamedVec a) b = reduce (Vec (removeNamesWithMap a)) b
    reduce (NamedLimited a) b = reduce (Limited (removeNamesAll a)) b
    toSVWGraphs  = (uncurry svwGraphsOfAutomata) . ensureContainment .  toAutomata


instance Buechi (Automaton, Automaton) where
    solve (aut1, aut2) = aut1 `contains` aut2
    toString = (stringOfAutomata Raskin) . Left
    toAutomata x = Left x
    reduce x _ = x
    toScGraphs (aut1, aut2) = scGraphsOfAutomata aut1 aut2
    toSVWGraphs = uncurry svwGraphsOfAutomata


instance Buechi Automaton where
    solve aut = (univ aut) `contains` aut
    toString = (stringOfAutomata Raskin) . Right
    toAutomata x = Right x
    reduce x _ = (univ x, x)
    toScGraphs aut = scGraphsOfAutomata (univ aut) aut
    toSVWGraphs aut = svwGraphsOfAutomata (univ aut) aut

     
instance Buechi SVWGraphs where
    solve acgs = check_lasso acgs 
    toString = stringOfSVWGraphs
    toAutomata x = error "Not implemented" 
    reduce _ _ = error "Not implemented"
    --Since we've already translted to edge-acceptance from state-acceptance, this is a pain.
    toScGraphs (gs, _, fa, _) = Limited (gs, vecOfScgraphs gs, fa)
    toSVWGraphs acgs = acgs

instance Buechi ((Automaton, Automaton), Bool) where
    solve ((aut1, aut2), True) = aut1 `seth_contains` aut2
    solve (red, False) = solve red
    toString  = toString.fst
    toAutomata  = toAutomata.fst
    reduce  = reduce.fst
    toScGraphs  = toScGraphs.fst
    toSVWGraphs = toSVWGraphs.fst

instance Buechi (Scgraphs, Bool) where
    toString (scgs, b) = stringOfScgraphs b scgs
    solve  = solve.fst
    toAutomata  = toAutomata.fst
    reduce  = reduce.fst
    toScGraphs  = toScGraphs.fst
    toSVWGraphs = toSVWGraphs.fst
     
instance Buechi (SVWGraphs, Bool) where
    toString (p, True) = setOfSVWGraphs p
    toString (p, False) = stringOfSVWGraphs p
    solve  = solve.fst
    toAutomata  = toAutomata.fst
    reduce  = reduce.fst
    toScGraphs  = toScGraphs.fst
    toSVWGraphs = toSVWGraphs.fst

instance (Buechi a, Buechi b) => Buechi (Either a b) where
    solve (Left x) = solve x
    solve (Right x) = solve x
    toString (Left x) = toString x
    toString (Right x) = toString x
    toAutomata (Left x) = toAutomata x
    toAutomata (Right x) = toAutomata x
    reduce (Left x) = reduce x
    reduce (Right x) = reduce x
    toScGraphs (Left x) = toScGraphs x
    toScGraphs (Right x) = toScGraphs x
    toSVWGraphs (Left x) = toSVWGraphs x
    toSVWGraphs (Right x) = toSVWGraphs x
