{--
  
  Material dependency analysis
  ----------------------------

--}
module CallgraphExtract where

import Asyntax
import Prim
import List hiding ( union )
import Set

--
-- Compute Material dependencies
--
extractCallgraph pgm@(Prog fds) = concat (map (cgextFD pgm) fds)
mainFunction (Prog ((FD f _ _):_)) = f
allFunctions (Prog fds) = nub (map (\(FD f _ _) ->  f) fds)

cgextFD pgm (FD f xs e) = 
  nub (cgextExp pgm f e)


--
-- Expression evaluation
--

-- Evaluate a variable
cgextExp pgm f (Var x) = []

-- Evaluate a constructor application
-- (zero, one, or more parameters allowed) 
cgextExp pgm f (Con cname es) = cgextList pgm f es

-- Evaluate a destructor application
-- (at least one parameter will be present)
cgextExp pgm f (Des cname es) = cgextList pgm f es

-- Evaulation of unannotated function calls is not allowed
cgextExp pgm f (App fname es) =
  error ("Call to function " ++ fname ++ " is not annotated.")

-- Evaluate a function application
cgextExp pgm@(Prog fds) f (Fapp sn fname es) = 
  let av0 = cgextList pgm f es
  in
    case lookup fname primitiveFunctionScgraphs of
      Just g -> av0
      Nothing -> (f, fname) : av0
 
-- Evaluate a conditional expression
cgextExp pgm f (If e0 e1 e2) = (cgextExp pgm f e1) 
                               ++ (cgextExp pgm f e2)

-- Evaluate a let expression
cgextExp pgm f (Let ds e0) =
  let
    av0 = concat (map
             (\(Def x e1)->
               cgextExp pgm f e1
             )
             ds)
  in (cgextExp pgm f e0) ++ av0


-- Evaluate a list of expressions
cgextList pgm f es = concat (map (cgextExp pgm f) es)
