{--
  
  Material dependency analysis
  ----------------------------

--}
module Dependency where

import Asyntax
import Prim
import List hiding ( union )
import Set
import Env

--
-- Compute Material dependencies
--
matdep pgm@(Prog fds) = map (matdepFD pgm) fds

matdepFD pgm (FD f xs e) = 
--  (f, matdepFix pgm (zip xs (map sing xs)) e empty)
  (f, matdepExp pgm (zip xs (map sing xs)) [] e)


-- Reevaluate an expression until a fixpoint is reached
matdepFix pgm xs e av =
  let av0 = matdepExp pgm xs [] e
  in if av0==av
     then av0
     else matdepFix pgm xs e av0

--
-- Expression evaluation
--

-- Evaluate a variable
matdepExp pgm env cs (Var x) =
  case lookup x env of
    Nothing -> error ("Variable " ++ x ++ " is undefined.")
    Just v  -> v

-- Evaluate a constructor application
-- (zero, one, or more parameters allowed) 
matdepExp pgm env cs (Con cname es) = 
  foldl union empty (matdepList pgm env cs es)

-- Evaluate a destructor application
-- (at least one parameter will be present)
matdepExp pgm env cs (Des cname es) = 
  foldl union empty (matdepList pgm env cs es)

-- Evaulation of unannotated function calls is not allowed
matdepExp pgm env cs (App fname es) =
  error ("Call to function " ++ fname ++ " is not annotated.")

-- Evaluate a function application
matdepExp pgm@(Prog fds) env cs (Fapp sn fname es) = 
  let av0 = matdepList pgm env cs es
  in
    case lookup fname primitiveFunctionScgraphs of
      Just g -> foldl union empty av0
      Nothing ->
        let (xs, e) = case find (\(FD f _ _)->f==fname) fds of
                        Just (FD f xs e) -> (xs, e)
                        Nothing -> error ("Undefined function "++fname)
            fkey = (fname, av0)
        in if not ((length xs)==(length av0))
             then error ("Invalid arity in call to " ++ fname)
             else case lookup fname cs of
               Nothing -> matdepExp pgm (zip xs av0) (update fname av0 cs) e
               Just avOld ->
                 let avNew = map (uncurry union) (zip av0 avOld)
                 in if avOld==avNew
                      then empty --foldl union empty avNew
                      else matdepExp pgm (zip xs av0) (update fname avNew cs) e
 
-- Evaluate a conditional expression
matdepExp pgm env cs (If e0 e1 e2) = union (matdepExp pgm env cs e1) 
                                           (matdepExp pgm env cs e2)

-- Evaluate a let expression
matdepExp pgm env cs (Let ds e0) =
  let
    env0 = foldl
             (\env1->(\(Def x e1)->
               (x, matdepExp pgm env1 cs e1) : env1
             ))
             env
             ds
  in matdepExp pgm env0 cs e0


-- Evaluate a list of expressions
matdepList pgm env cs es = map (matdepExp pgm env cs) es
