module GroundedGraphs where
import List
import Maybe
import Automata
import Graphs
import Scgraph 

--We now keep track of the source and sink states, and restrict composition
--accordingly. This SHOULD restrict us to only reachable graphs.
data GGraph = GG (Param, [State]) Arcs (Param, [State]) Word deriving Show

--
instance Eq GGraph where { 
(==) (GG src as snk _) (GG src' as' snk' _) = (as,src,snk) == (as', src', snk')}

instance Ord GGraph where { 
(<) (GG src as snk _) (GG src' as' snk' _) = (src,as,snk) < (src',as',snk') }

--instance Show SGraph where { -- we don't show their paths by default Seth: We do now
--show (SG (f, r, f') src as snk path) = ' ':show f++'-':show path++show r++show f'++':':show as }

--                          Composition of graphs

instance Composable GGraph where 
    composG (GG (f, src) as (g, snk) cs) (GG (g', src') as' (h, snk') cs') | g == g' && snk == src' = 
      GG (f, src) (composAs as as') (h, snk') (cs ++ cs')
      where
       composAs xs ys = let as = nub (composAs2 xs ys)
                        in filter (keepA as) as
       composAs2 xs ys = 
                    [(s, r `composR` r', t') | (s,r,t)<-xs, (s',r',t')<-ys, t==s' ]
       keepA as (s,r,t) = 
               and (map (\x->(composR r x) == r) [r' | (s',r',t')<-as, s==s', t==t'])
       composR Gte Gte = Gte
       composR Gte Gt  = Gt
       composR Gt  Gte = Gt
       composR Gt  Gt  = Gt
    
    composG g1 g2 = error ("incompatible automata graphs:\n "++show g1++"\n"++show g2)


    normaliseG (GG src arcs snk path) = GG src (nub(sort arcs)) snk path
    canCompose (GG  _ _ snk _) (GG  src' _ _ _) = snk == src'
    loopingArc (GG src _ snk _)  = snk == src
    


seth_contains :: Automaton -> Automaton -> Bool
aut1 `seth_contains` aut2 = 
            let red = clean_red (aut1, aut2) 
                start_graphs = init_graphs red
                unit_graphs = fixedpoint (normalise.(extend red)) start_graphs
                desc_param (n,rel,n') = rel == Gt && n==n'
                has_desc_param = any desc_param
                (Automaton _ _ _ _ fa) = aut1 
            in all has_desc_param 
                [ as | g@(GG (f, src) as (f', snk) _)<-s unit_graphs, f==f',
                       src==snk, elem f fa, g == normaliseG (composG g g) ]



init_graphs :: (Automaton, Automaton) -> [GGraph]
init_graphs ((Automaton sigmaA statesA startA rhoA finalA), (Automaton sigmaB statesB startB rhoB finalB)) = 
       graphs
       where
         graphs = [GG (f, nstartB) (arcs c) (g, sinks c) [c] | (f, c, g) <- rhoA, elem f startA]
         init_rhoB= [(a, i, b) | (a, i, b) <- rhoB, elem a startB] 
         arcs c = [(a, (descB b), b) | (a, i, b) <- init_rhoB, i == c] 
         nstartB = sort (startB) --always sort sinks and sources.
         sinks c = sort (nub [b  | (a, i, b) <- init_rhoB, i == c]) 
         ---alllllwaayyyys keep sinks and sources sorted.
         descB state = if elem state finalB then Gt else Gte


step :: (Automaton, Automaton) -> GGraph -> [GGraph]
step ((Automaton sigmaA statesA startA rhoA finalA),
     (Automaton sigmaB statesB startB rhoB finalB)) 
     (GG (f, src) as (g, snk) wrd) =
     [step_c c g' | (f', c, g') <- rhoA, g==f']
     where
         step_c c g' = GG (g, snk) (arcs c) (g', sinks c) [c]
         arcs c = [(a, (descB b), b) | (a, i, b) <- rhoB, elem a snk, i == c]
         sinks c = nub (sort [b  | (a, i, b) <- rhoB, elem a snk, i == c]) ---alllllwaayyyys keep sinks and sources sorted.
         descA state = if elem state finalA then Gt else Gte
         descB state = if elem state finalB then Gt else Gte

extend :: (Automaton, Automaton) -> [GGraph] -> [GGraph]
extend red graphs = concatMap (step red) graphs




--Conversions from automata are all based on grounded graphs.

sGraphsOfAutomata :: Automaton -> Automaton -> ([GGraph], [((State, [State]), Int)], [Param])
sGraphsOfAutomata aut1 aut2 =
            (unit_graphs, vec, fa)
            where
                red = clean_red (aut1, aut2) 
                start_graphs = init_graphs red
                unit_graphs = fixedpoint (normalise.(extend red)) start_graphs
                get_vecs (GG (f, src) as (g, snk) wrd) = [((f, src), length src), ((g, snk), length snk)]
                vec = nub (concatMap get_vecs unit_graphs)
                (Automaton _ _ _ _ fa) = aut1 

scGraphsOfAutomata :: Automaton -> Automaton -> Scgraphs 
scGraphsOfAutomata aut1  aut2 = 
            let to_scgraph (GG (f,src) as (g,snk) wrd) = 
                        Scgraph.G fname gname as' wrd
                        where
                            fname = num (f,src)
                            gname = num (g,snk)
                            as' = map (\ (a,b,c) -> (rank src a,b,rank snk c)) as
                (graphs, gvecs, fa) = sGraphsOfAutomata aut1 aut2
                scgs = map to_scgraph graphs
                vecs = map (\ ((a,b),c) -> (num (a,b), c)) gvecs
                names = nub (concatMap (\ (GG (f,src) _ (g,snk) _) -> 
                            [(f,src), (g,snk)]) graphs)
                num = rank names
                fa' = mapMaybe 
                      (\ ((a,b),_) -> 
                        if elem a fa 
                        then Just (num (a, b))
                        else Nothing) gvecs
            in Limited (scgs, vecs, fa')

            
