
module Parser(parse) where

import Asyntax

import Lexer

import ParseLib

parse = (parser pProg . lexer)

-- Program:


pProg = Prog `mapP` someP pFD


-- Declarations:

pFD = ( \ ((fname,params),e) -> FD fname params e) `mapP`
      ident `leftP` symb "(" `thenP` pParams pId `leftP` symb ")" `leftP`
      symb "=" `thenP` pExp



-- Parse a comma separated list of arg's
pParams arg = (uncurry (:)) `mapP` arg `thenP`
              manyP (symb "," `rightP` arg)


-- Parse a single let binding
pVardef = (\(var,exp)->Def var exp) `mapP`
          (pId `leftP` symb "=" `thenP` pExp)
               
-- Parse a sequence of single let bindings
pVardefs = (uncurry (:)) `mapP` pVardef `thenP`
           manyP pVardef


{-- Expressions:

  Exp ::= x
        | constr
        | fun(x_1, ..., x_n)
        | cons(x_1, ..., x_n)
        | destr(x_1, ..., x_n)
        | if exp_0 then exp_1 else exp_2
        | let x_1 = exp_1 ... x_n = exp_n in exp

  Where:
    n      >   0
    x      \in VariableNames
    fun    \in FunctionNames
    destr  \in DestructorNames
    constr \in ConstructorNames
  
--}
--(\(x)->Var x) `mapP` ident `elseP`
pExp = (Var `mapP` pId) `elseP`
       ((\x->Con x []) `mapP` pCons) `elseP`
       pFapp ident App `elseP`
       pFapp pCons Con `elseP`
       pFapp pDestr Des `elseP`
       ((\((ifexp, thenexp), elseexp)->If ifexp thenexp elseexp) `mapP`
         (key "if"   `rightP` pExp) `thenP` 
         (key "then" `rightP` pExp) `thenP`
         (key "else" `rightP` pExp)
       ) `elseP`
       ((\(defs, exp)->Let defs exp) `mapP`
         (key "let" `rightP` pVardefs) `thenP`
         (key "in"  `rightP` pExp)
       ) `elseP`
       (symb "("  `rightP` pExp `leftP` symb ")" )
 

-- Parse function like structures (functions, destructors, constructors)
pFapp pfn tag = 
       (uncurry tag `mapP` 
       pfn `leftP` symb "(" `thenP` pParams pExp `leftP` symb ")") 

-- Parse a token of a given type
pCons = fst `mapP` match ((==Cons).snd)
pDestr = fst `mapP` match ((==Destr).snd)

-- Parse a identifier
--pId = (\(n, p)->(n, length p)) `mapP` ident `thenP` manyP (symb "\'")
pId = (\(n, p)->n) `mapP` ident `thenP` manyP (symb "\'")















