module Pathologies where

import Asyntax
import Scgraph
import Graphs
import List


bitstring :: Int -> ((Program, NCallgraph), [NamedScgraph])
bitstring n =
   ((pgm, csOfNGraphs graphs), graphs)
    where
        graphs = union
           [NG "a" "b" (a_arcs (k*2+1)) [] | k <- [0..(n-1)]]
           [NG "b" "a" (b_arcs (k*2)) [] | k <- [1..n]]
        j = (2*n)+1
        base = [(x,Gte,x) | x <- [0..2*(n)]]
        a_arcs k = base++[(k,Gt,j)]
        b_arcs k = base++[(j,Gte,k)]

        pgm = Prog [(FD "a" aparms (Var "")), (FD "b" bparms (Var ""))]
        aparms = [show x | x <- [0..(2*n)]]
        bparms = aparms ++ ["j"]


tightbitstring :: Int -> ((Program, NCallgraph), [NamedScgraph])
tightbitstring n =
   ((pgm, csOfNGraphs graphs), graphs)
    where
        graphs = union
            [NG "a" "b" (a_arcs k) [] | k <- [1..n]]
            [NG "b" "a" (b_arcs k) [] | k <- [1..n]]
        j = n+1
        base = [(x,Gte,x) | x <- [0..n]]
        a_arcs k = base++[(k,Gt,j)]
        b_arcs k = base++[(j,Gte,k)]
        
        pgm = Prog [(FD "a" aparms (Var "")), (FD "b" bparms (Var ""))]
        aparms = [show x | x <- [0..n]]
        bparms = aparms++["j"]


loeding :: Int -> ((Program, NCallgraph), [NamedScgraph])
loeding n =
   ((pgm, csOfNGraphs graphs), graphs)
    where
        graphs = [NG "f" "f" (loeding_arcs k) [] | k <- [1..n]]++hashgraph
        j = n+1
        base = [(x, Gte, x) | x <- [0..n]]
        loeding_arcs k = base++[(k, Gt, j), (j, Gte, k)]
        hashgraph = [NG "f" "f" base []]
        
        pgm = Prog [(FD "f" parms (Var ""))]
        parms = [show x | x <- [0..(n+1)]]

compactloeding :: Int -> ((Program, NCallgraph), [NamedScgraph])
compactloeding n =
   ((pgm, csOfNGraphs graphs), graphs)
    where
        graphs = [(NG "f" "f" a_arcs []), (NG "f" "f" b_arcs []), (NG "f" "f" hasharcs [])]
        j = (4*n)+1
        base = (0, Gte, 0)
        v n = (4*(n-1))+1
        h n = (4*(n-1))+2
        i n =  (4*(n-1))+3
        o n =  (4*(n-1))+4
        
        a_arcs = base:(concat [a_h_arcs k++a_i_arcs k++a_o_arcs k | k <- [1..n]]) ++ [(i n, Gte, i n)]
        a_h_arcs k = [(v k, Gte, h k), (h k, Gte, h k)]
        a_i_arcs k = if k == 1 
                    then [(j, Gte, i k)]
                    else [(i (k-1), Gte, i k)]
        a_o_arcs k =  if k == n
                      then [(v k, Gte, o k), (o k, Gte, o k)]
                      else [(v k, Gte, o k), (o (k+1), Gte, o k)]
    
        b_arcs = base:(concat [[(v k, Gte, v k), (h k, Gte, v k), (i k, Gte, v k)] | k <- [1..n]]) ++ [(o 1, Gt, j)]
    
        hasharcs = base:[(v k, Gte, v k) | k <- [1..n]] 
            
        pgm = Prog [(FD "f" parms (Var ""))]
        parms = [show x | x <- [0..((4*n)+1)]]
