module Prim where

import Abs
import Asyntax

--
-- Size-changegraphs for primitive functions
--
-- This is a collection a size-change graphs for primitive functions
-- and library functions
primitiveFunctionScgraphs = 
 [
 ("eq",     [scarcDecEq, scarcDecEq]),
 ("equal",  [scarcDecEq, scarcDecEq]),
 ("arity",  (makeTop 1)),
 ("error",  (makeTop 1)),

 ("not",    [scarcDecEq]),
 ("and",    [scarcDecEq, scarcDecEq]),
 ("add",    [scarcDecEq, scarcDecEq]),
 ("mul",    [scarcDecEq, scarcDecEq]),
 ("sub",    [scarcDecEq, scarcDecEq]),
 ("or",     [scarcDecEq, scarcDecEq]),
 ("gt",     [scarcDecEq, scarcDecEq]),
 ("ge",     [scarcDecEq, scarcDecEq]),
 ("le",     [scarcDecEq, scarcDecEq]),
 ("lt",     [scarcDecEq, scarcDecEq]),
 ("gte",    [scarcDecEq, scarcDecEq]),
 ("lte",    [scarcDecEq, scarcDecEq]),
 ("min",    [scarcDecEq, scarcDecEq])
 ]
{--
 ("add",    [scarcIncEq, scarcIncEq]),
 ("sub",    [scarcDecEq, scarcTop  ]),
 ("mul",    [scarcIncEq, scarcIncEq]),
 ("div",    (makeTop 2))
--}

--Primitive depExps are NOT the same as normal depexps. Normally, a depexp of ['a','b'] means that our size relies on |a|+|b|
--Here we instead mean our size is BOUNDED by |a| and |b|. 
primDepExps :: String -> [Exp] -> [Exp]

primDepExps "min" es = es

primDepExps other es = []

primGamma :: String -> Maybe Int

primGamma "min" = Just 0
primGamma other = Nothing
