module SCRed where
import IO
import Scgraph
import List
import CallgraphExtract
import Automata
import Asyntax
import Graphs
import Control.Exception


type Function = Int

flowOfGraphs :: Callgraph -> Function -> Automaton
flowOfGraphs cs start =
  Automaton sigma states init rho states --what is finitial?
  where
    init  = if start == (-1) then states else [start]
    sigma = length cs
    fnames = nub (foldl (\ acc (i,(n1, n2)) -> n1:n2:acc) [] cs)
    --ftostate  = rank fnames
    states  = fnames
    rho = nub (foldl (\ acc (i, (n1, n2)) -> (n1,i,n2):acc) [] cs)

oldDescOfGraphs :: [Scgraph] -> Callgraph -> Function -> (Function -> [String]) -> Automaton 
oldDescOfGraphs graphs cs startState paramsByFname = 
  Automaton sigma states start rho final 
  --error ("Mapping is: "++(show mapping)++"\nAutomata\n"++(show aut)++"\nPrint\n"++(stringOfAutomaton Raskin aut))  
  where
    fcnMax = maximum fcnNames
    tostate str = (rank c1states str) + fcnMax
    states = union (map tostate c1states) fcnNames
    start = union (map tostate c1start) finit
    torho (a,b,c) = (tostate a, b, tostate c)
    rho = union (map torho c1rho) (union rho2 frho)
    final = map tostate c1final
    --we start in flow and leave at some point
    sigma = length cs
    fcnNames  = nub (foldl (\ acc (i,(n1, n2)) -> n1:n2:acc) [] cs)
    finit  = if startState == (-1) then fcnNames else [startState]
    frho = nub (foldl (\ acc (i, (n1, n2)) -> (n1,i,n2):acc) [] cs)
    --c1 is the first component 
    c1states = [param++(show value) | param <- parameters, value <- [Gt, Gte]]
    c1start = [param++(show Gte) | param <- paramInit]
    c1final =  [param++(show Gt) | param <- parameters]
    c1rho = sort [((showParam p1 x) ++ (show r), c, (showParam p2 x') ++ (show r')) |
            (G p1 p2 arcs [c]) <- graphs, (x, r', x') <- arcs, r <- [Gt, Gte]]
    -- 
    rho2 = nub [(f, c, tostate (x++(show Gte))) | (c, (f, g)) <- cs, x <- (paramsByFname g)] 
    --basic measures of parameters and such
    parameters = nub (foldl (\ acc fname -> union (paramsByFname fname) acc) [] fcnNames)
    paramInit = if startState == -1 then concatMap paramsByFname fcnNames else paramsByFname startState

descOfGraphs :: [Scgraph] -> Callgraph -> Function ->  (Function -> Int) -> Int -> Automaton
descOfGraphs graphs cs startState rankByFname maxRank = 
  --if (sort rho) == (sort (nub rho)) then Automaton sigma states start rho final else error "BAD RHO!"
  Automaton sigma states start rho final
  where
    mapping = zip c1states [1..]
    tostate :: String -> State = \ name -> case lookup name mapping of 
                        Just i -> i
                        _ -> error ("Error in mapping names to states: "++name++"\n"++(show mapping))
    torho (a,b,c) = (tostate a, b, tostate c)
    states = 0:(map tostate c1states)
    start  = 0:(map tostate c1start)
    rho =  (wrho++lrho)++(map torho c1rho)
    final = map tostate c1final
    sigma = length cs
    --we start in a waiting state
    wrho = [(0, s, 0) | s <- [0..(sigma-1)]] 
    --  at some point we leave the waiting state
    lrho = nub [(0, c, tostate ((show x)++(show Gte))) | (c, (f, g)) <- cs, x <- [0..((rankByFname g)-1)]] 
    --c1 is the first component 
    c1states = [param++(show value) | param <- parameters, value <- [Gt, Gte]]
    c1start = [param++(show Gte) | param <- paramInit]
    c1final =  [param++(show Gt) | param <- parameters]
    c1rho = [((show x) ++ (show r), c, (show x') ++ (show r')) |
            (G p1 p2 arcs [c]) <- graphs, (x, r', x') <- arcs, r <- [Gt, Gte]]
    --basic measures of parameters and such
    parameters = map show [0..(maxRank-1)]
    initMax = if startState == -1 then maxRank else rankByFname startState
    paramInit = map show [0..(initMax-1)]


ngraphContainsLetter (NG _ _ _ [c]) = True
ngraphContainsLetter _ = False

scReduction :: Bool -> (Program, NCallgraph) -> [NamedScgraph] -> (Automaton, Automaton)
scReduction original (pgm, cs) graphs =
   let functions = allFunctions pgm
       toFunction = rank functions
       newcs = map (\(x,(a,b)) -> (x, (toFunction a, toFunction b))) cs
       newgraphs = map (removeName functions) graphs
       mainF = toFunction (mainFunction pgm)
       toName a  = functions!!(fromIntegral a)
       flow = (assert (and (map ngraphContainsLetter graphs))) (flowOfGraphs newcs mainF) in
   let desc = if original 
              then oldDescOfGraphs newgraphs newcs mainF ((paramsOfFunc pgm).toName)
              else descOfGraphs newgraphs newcs mainF  ((rankOfFunc pgm).toName) (rankOfPgm pgm) in
   (flow, desc)

graphContainsLetter (G _ _ _ [c]) = True
graphContainsLetter _ = False

graphReduction :: Bool -> Callgraph -> Function -> [(Function, Int)] -> [Scgraph] -> (Automaton, Automaton)
graphReduction original cs mainF rankOfFunc graphs =
   let flow = (assert (and (map graphContainsLetter graphs))) (flowOfGraphs cs mainF)
       maxRank = maximum (map snd rankOfFunc)
       r_of_f f = case lookup f rankOfFunc of
           Just i -> i
           Nothing -> error ("Can not find rank of function " ++ (show f))
       paramsOfFunc fname = map (\x -> (show fname) ++"_"++(show x)) [0..(r_of_f fname)-1]
       desc = if original 
              then oldDescOfGraphs graphs cs mainF paramsOfFunc 
              else descOfGraphs graphs cs mainF r_of_f maxRank 
   in (flow, desc)

--ex3graph1 = G "A" "A" [(1, Gt, 1)] [1]
--ex3graph2 = G "A" "A" [(1, Gt, 1)] [2]
--ex3graph3 = G "A" "A" [(1, Gte, 1), (2, Gt, 2)] [3]
--graphs = [ex3graph1, ex3graph2, ex3graph3]


