module Scc where

import List
import Scgraph

import Array 

data Comp = Scc    [String]
          | NonScc [String]

compAll x = True
compScc (Scc x)    = True
compScc (NonScc x) = False

getComp (Scc c)    = c
getComp (NonScc c) = c

foldrComp f p i xs = foldr (appf f p) i xs
  where appf f p y x = if (p x) then (f (getComp x) y) else y
foldlComp f p i xs = foldl (appf f p) i xs
  where appf f p y x = if (p x) then (f y (getComp x)) else y
mapComp f p [] = []
mapComp f p (x:xs) = 
  if (p x) then (f (getComp x)) : mapComp f p xs
           else                   mapComp f p xs


instance Show Comp where
  show = (\x->case x of
                (Scc xs)    -> "Scc: "++(show xs)
                (NonScc xs) -> "NonScc: "++(show xs)
         )

--empty = []
member as x = elem x as
--union a b = union
--inter a b = intersect a b
--diff  a b = a \\ b

--
-- The Lockstep algorithm for finding strongly connected components (SCC)
--
-- R. Bloem, H. N. Gabow and F. Somenzi
--   "An algorithm for Strongly Connected 
--    Components Analysis in n log n Symbolic Steps"
--   University of Colorado at Boulder

-- Follow graph from vs
fwVtxs d gs vs = nub (concat (map (fwVtx d gs) vs))
fwVtx d gs v = 
  let ds = map d gs 
  in  [ w' | (v',w')<-ds, v'==v]

-- Directions
--fwd = (\(G x y _ _)->(x,y))
--back = (\(G x y _ _)->(x,y))
fwd = (\(x,y)->(x,y))
back = (\(x,y)->(y,x))


-- Sort vertices topologically (forward)
topoSort i gs = 
  vt [i] [i] (fwVtx fwd gs)
  where vt [] visited img = []
        vt (v:vs) visited img =
              let front = (img v) \\ visited
              in  v : vt (union front vs) (union front visited) img

topoSort2 i gs = 
  vt [i] [i] (fwVtx fwd gs)
  where vt [] visited img = []
        vt (v:vs) visited img =
              let front = (img v) \\ visited
              in  (v, front) : vt (union front vs) (union front visited) img


--
sccLSTP v gs = sccLockstep (topoSort v gs)
                           (fwVtxs fwd gs) (fwVtxs back gs)

sccLockstep [] img preimg = []
sccLockstep (v:vs) img preimg = 
    let (conv, comp) = progressLockstepDual 
                       [v] [v] [v] [v] img preimg
        vs2          = vs \\ comp
        conv2        = conv \\ comp
        (conv_sub_comp, vs_sub_conv) = partition (member conv2) vs2
        rest = (sccLockstep conv_sub_comp img preimg)
            ++ (sccLockstep vs_sub_conv   img preimg)
    in if (comp==[])
         then []
         else if (and (map (member (img comp)) comp))
                then (Scc comp) : rest
                else (NonScc comp) : rest
  
progressLockstepDual f fFront b bFront img preimg = 
  if (fFront==[])
    then (f, (intersect f (progressLockstepSingle preimg b bFront f)))
  else if (bFront==[])
    then (b, (intersect b (progressLockstepSingle img    f fFront b)))
    else
      let df = img    fFront
          db = preimg bFront
      in progressLockstepDual (union f df) (df \\ f) 
                              (union b db) (db \\ b) 
                              img preimg
            
progressLockstepSingle progress x xFront bound =
  if ((intersect xFront bound)==[]) 
    then x
    else
      let dx = (progress xFront)
      in progressLockstepSingle progress (union x dx) (dx \\ x) bound
