{--
       

--}
module Unique where

import Scgraph
--import Asyntax
import Abs
import Set

-------------------------------------------------------------------------------
--
-- Extract unique paths from not_sat 
-- 
-- (unique under rotation of the call sequence)
--
rotate (x:xs) = xs ++ [x]

firstCall (G _ _ _ (x:xs)) = x

mpEq (G _ _ _ n1) (G _ _ _ n2) = mpEqPath n1 n2 (length n2)
mpEqPath n1 n2 n =
  if   n == 0    then False
  else if n1==n2 then True 
  else mpEqPath n1 (rotate n2) (n-1)

mpMinimize gs (G f1 f2 as path) = 
  let newpath@(p:ps) = (mpMinimizePath path path (length path)) 
      g1 = head [h1 | (G h1 _ _ [x])<-gs, x==p]
  in (G g1 g1 as newpath)
mpMinimizePath path@(p:_) min@(m:_) n =
  if n==0 then min 
    else 
      let min2 = if p < m then path else min
      in mpMinimizePath (rotate path) min2 (n-1)
       
insertEq gs m unqs =
  let min = mpMinimize gs m 
  in if null [x | x<-unqs, (mpEq x min)]
       then unqs ++ [min]
       else unqs

uniqueMp gs mps = foldr (insertEq gs) [] mps
  
