/* ArithExpr ::= Const(int) | Sum(ArithExpr, ArithExpr)  | 
                 Prod(ArithExpr, ArithExpr) | Neg(ArithExpr)

abstract class ArithExpr {

  /* samle instances */
  static ArithExpr e1 = 
    new Sum(new Prod(new Const(5),new Const(7)),new Const(17));
  static  ArithExpr e2 = new Neg(e1);
  static  ArithExpr e3 = new Prod(e1,e2);

  static void test() {
    System.out.println(e1);
    System.out.println(e2);
    System.out.println(e3);
  }
  public static void main(String[] args) { test(); }
}

class Const extends ArithExpr {
  int value;

  Const(int v) { value = v; }
  public String toString() { return Integer.toString(value); }
}


class Sum extends ArithExpr {
  ArithExpr left,right;

  Sum(ArithExpr l, ArithExpr r) { 
    left = l; right = r;
  }
  public String toString() { return "(" + left + "+" + right + ")"; }
}

class Prod extends ArithExpr {
  ArithExpr left,right;

  Prod(ArithExpr l, ArithExpr r) { 
    left = l; right = r;
  }
  public String toString() { return left + "*" + right; }
}

class Neg extends ArithExpr {
  ArithExpr expr;

  Neg(ArithExpr e) { expr = e; }
  public String toString() { return "-" + expr; }
}

