class SyncPCount extends Thread {

  static int sharedCtr = 0;
  static final int cntPerThread = 1000000;
  static final int noOfThreads = 10;
  
  int id; 

  SyncPCount(int i) { id = i; }

  synchronized static void inc() {
    sharedCtr++;
  }
  public void run() {
    for (int i = 0; i < cntPerThread; i++) inc();
    System.out.println("Thread #" + id + " has completed; sharedCtr = " + sharedCtr);
  }

  public static void main(String[] args) throws InterruptedException {
    Thread[] tPool = new Thread[noOfThreads];
    for (int j = 0; j < noOfThreads; j++) {
      tPool[j] = new SyncPCount(j);
    }
    for (int j = 0; j < noOfThreads; j++) {
      tPool[j].start();
    }
    for (int j = 0; j < noOfThreads; j++) {
      tPool[j].join();
    }
    System.out.println("Computation complete.  sharedCtr = " + sharedCtr);
  }
}

