import java.awt.*;
import java.applet.*;
import java.awt.event.*;

class Main {
  public static void main(String[] args) {
    Frame frame = new Frame("Click Counter Demo");
    ClickCounterControl theInterface = new ClickCounterControl();
    theInterface.init();
    frame.add(theInterface, "Center");
    frame.pack();
    frame.setVisible(true);
  }
}

class ClickCounterView {
  
  // ** fields **
  private Button incButton;
  private Button resetButton;
  private Button decButton;
  private Label valueDisplay;
  
  // ** constructors **
  public ClickCounterView(Applet itsApplet) {
    Panel controlPanel = new Panel();
    
    itsApplet.setFont(new Font(null,Font.BOLD,30));
    itsApplet.setLayout(new BorderLayout());
    valueDisplay = new Label("000", Label.CENTER);
    
    itsApplet.add(new Label("Click Counter", Label.CENTER), "North"); 
    itsApplet.add(valueDisplay, "Center");
    
    incButton = new Button("+");
    resetButton = new Button("MIN");
    decButton = new Button("-");
    
    controlPanel.add(incButton);
    controlPanel.add(resetButton);
    controlPanel.add(decButton);
    itsApplet.add(controlPanel, "South");
  } 
  
  // ** methods **
  public void setValueDisplay(String setTo) {
    valueDisplay.setText(setTo);
  }
  
  public void addIncListener(ActionListener a) { 
    incButton.addActionListener(a);
  }
  
  public void addDecListener(ActionListener a) { 
    decButton.addActionListener(a);
  }
  
  public void addResetListener(ActionListener a) { 
    resetButton.addActionListener(a);
  }
  
  public void setMinimumState() {
    incButton.setEnabled(true);
    resetButton.setEnabled(false);
    decButton.setEnabled(false);
  }
  
  public void setCountingState() {
    incButton.setEnabled(true);
    resetButton.setEnabled(true);
    decButton.setEnabled(true);
  }
  
  public void setMaximumState() {
    incButton.setEnabled(false);
    resetButton.setEnabled(true);
    decButton.setEnabled(true);
  }
}
class ClickCounter {
  
  private static final int MAXIMUM = 99;
  private static final int MINIMUM = 0;
  private static final int STRING_WIDTH = 2;

  // ** fields **
  private int count = MINIMUM;
  
  // ** constructor **
  public ClickCounter() {}
  
  // ** methods **
  public boolean isAtMinimum() { return count == MINIMUM; }
  public boolean isAtMaximum() { return count == MAXIMUM; }
  
  public int inc() { 
    if (! this.isAtMaximum()) count++; 
    return count;
  }

  public int dec() { 
    if (! this.isAtMinimum()) count--; 
    return count;
  }
  
  public void reset() { count = MINIMUM; }
  
  public int getCount() { return count; }
  
  // ** toString() **
  public String toString() {
    // returns low-order digits of decimal representation of counter value 
    // STRING_WIDTH specifies the number of digits
    StringBuffer buffer = 
    new StringBuffer(Integer.toString(count));
    while (buffer.length() < STRING_WIDTH) buffer.insert(0,0);
    return buffer.toString();
  }
}

