class ClickCounter {
  
  private static final int MAXIMUM = 99;
  private static final int MINIMUM = 0;
  private static final int STRING_WIDTH = 2;

  // ** fields **
  private int count = MINIMUM;
  
  // ** constructor **
  public ClickCounter() {}
  
  // ** methods **
  public boolean isAtMinimum() { return count == MINIMUM; }
  public boolean isAtMaximum() { return count == MAXIMUM; }
  
  public int inc() { 
    if (! this.isAtMaximum()) count++; 
    return count;
  }

  public int dec() { 
    if (! this.isAtMinimum()) count--; 
    return count;
  }
  
  public void reset() { count = MINIMUM; }
  
  public int getCount() { return count; }
  
  // ** toString() **
  public String toString() {
    // returns low-order digits of decimal representation of counter value 
    // STRING_WIDTH specifies the number of digits
    StringBuffer buffer = 
    new StringBuffer(Integer.toString(count));
    while (buffer.length() < STRING_WIDTH) buffer.insert(0,0);
    return buffer.toString();
  }
}
