import java.awt.*;
import java.applet.*;
import java.awt.event.*;

public class ClickCounterControl extends Applet {
  
  // ** fields **
  private ClickCounter counter;
  private ClickCounterView view;
  
  // ** constructors **
  // relying on default constructor
  
  // ** methods **
  // relying on inheritance from Applet
  
  public void init() {
    counter = new ClickCounter();
    view = new ClickCounterView(this);
    view.setMinimumState();
    view.setValueDisplay(counter.toString());
    
    
    view.addIncListener(new ActionListener(){
      public void actionPerformed(ActionEvent event) {
        if (counter.isAtMaximum()) return;
        if (counter.isAtMinimum()) view.setCountingState();
        counter.inc();
        view.setValueDisplay(counter.toString());
        if (counter.isAtMaximum()) view.setMaximumState();
      }
    });
    
    view.addDecListener(new ActionListener(){
      public void actionPerformed(ActionEvent event) {
        if (counter.isAtMinimum()) return;
        if (counter.isAtMaximum()) view.setCountingState();
        counter.dec();
        view.setValueDisplay(counter.toString());
        if (counter.isAtMinimum()) view.setMinimumState();
      }
    });
    
    view.addResetListener(new ActionListener(){
      public void actionPerformed(ActionEvent event) {
        counter.reset();
        view.setMinimumState();
        view.setValueDisplay(counter.toString());
      }
    });
  } 
}
