import java.awt.*;
import java.applet.*;
import java.awt.event.*;

class ClickCounterView {
  
  // ** fields **
  private Button incButton;
  private Button resetButton;
  private Button decButton;
  private Label valueDisplay;
  
  // ** constructors **
  public ClickCounterView(Applet itsApplet) {
    Panel controlPanel = new Panel();
    
    itsApplet.setFont(new Font(null,Font.BOLD,30));
    itsApplet.setLayout(new BorderLayout());
    valueDisplay = new Label("000", Label.CENTER);
    
    itsApplet.add(new Label("Click Counter", Label.CENTER), "North"); 
    itsApplet.add(valueDisplay, "Center");
    
    incButton = new Button("+");
    resetButton = new Button("MIN");
    decButton = new Button("-");
    
    controlPanel.add(incButton);
    controlPanel.add(resetButton);
    controlPanel.add(decButton);
    itsApplet.add(controlPanel, "South");
  } 
  
  // ** methods **
  public void setValueDisplay(String setTo) {
    valueDisplay.setText(setTo);
  }
  
  public void addIncListener(ActionListener a) { 
    incButton.addActionListener(a);
  }
  
  public void addDecListener(ActionListener a) { 
    decButton.addActionListener(a);
  }
  
  public void addResetListener(ActionListener a) { 
    resetButton.addActionListener(a);
  }
  
  public void setMinimumState() {
    incButton.setEnabled(true);
    resetButton.setEnabled(false);
    decButton.setEnabled(false);
  }
  
  public void setCountingState() {
    incButton.setEnabled(true);
    resetButton.setEnabled(true);
    decButton.setEnabled(true);
  }
  
  public void setMaximumState() {
    incButton.setEnabled(false);
    resetButton.setEnabled(true);
    decButton.setEnabled(true);
  }
}

