; Definition of data (make-entry name address phone)
;   name, address, and phone are strings

(define-struct entry (name address phone))

(define (lookup l key matcher picker)
  ; takes a list of entries l, a string key and functions picker, matcher: entry -> string
  (cond
    [(empty? l) false]
    [(cons? l) (if (string=? key (matcher (first l))) (picker (first l)) 
                   (lookup (rest l) key matcher picker))]))

(define d1 (cons (make-entry "Corky" "DH 3104" "x 6042") empty))
(define d2 (cons (make-entry "Matthias" "DH 3106" "x 5732") d1))
(define d3 (cons (make-entry "Paul" "DH 3109" "x 3720") d2))
